/// <reference path="./internal_*.d.ts" />
declare namespace dev.emi.emi.mixin.accessor {
    interface ItemRendererAccessor {
        abstract invokeRenderBakedItemModel(arg0: Internal.BakedModel_, arg1: Internal.ItemStack_, arg2: number, arg3: number, arg4: Internal.PoseStack_, arg5: Internal.VertexConsumer_): void;
        (arg0: Internal.BakedModel, arg1: Internal.ItemStack, arg2: number, arg3: number, arg4: Internal.PoseStack, arg5: Internal.VertexConsumer): void;
    }
    type ItemRendererAccessor_ = ItemRendererAccessor;
}
declare namespace Internal {
    interface OwoScreenHandler {
        createProperty<T>(klass: T, initial: T): Internal.SyncedProperty<T>;
        addClientboundMessage<R extends Internal.Record>(messageClass: R, handler: Internal.Consumer_<R>): void;
        addServerboundMessage<R extends Internal.Record>(messageClass: R, handler: Internal.Consumer_<R>): void;
        player(): Internal.Player;
        sendMessage<R extends Internal.Record>(message: R): void;
    }
    type OwoScreenHandler_ = OwoScreenHandler;
    class MarsBlockBlobFeature extends Internal.Feature<Internal.BlockStateConfiguration> {
        constructor(codec: Internal.Codec_<Internal.BlockStateConfiguration>)
    }
    type MarsBlockBlobFeature_ = MarsBlockBlobFeature;
    class SlimeTallGrassBlock extends Internal.BushBlock implements Internal.IShearable, Internal.IPlantable {
        constructor(properties: Internal.BlockBehaviour$Properties_, foliageType: Internal.SlimeType_)
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        getPlant(world: Internal.BlockGetter_, pos: BlockPos_): Internal.BlockState;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getFoliageType(): Internal.SlimeType;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<Internal.ItemStack>;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get foliageType(): Internal.SlimeType
    }
    type SlimeTallGrassBlock_ = SlimeTallGrassBlock;
    class SmithingTransformRecipe implements Internal.SmithingTransformRecipeAccessor, Internal.AccessorSmithingTransformRecipe, Internal.SmithingRecipe, net.p3pp3rf1y.sophisticatedbackpacks.mixin.common.accessor.SmithingTransformRecipeAccessor, com.illusivesoulworks.polymorph.mixin.core.AccessorSmithingTransformRecipe {
        constructor($$0: ResourceLocation_, $$1: Internal.Ingredient_, $$2: Internal.Ingredient_, $$3: Internal.Ingredient_, $$4: Internal.ItemStack_)
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        isBaseIngredient($$0: Internal.ItemStack_): boolean;
        getTemplate(): Internal.Ingredient;
        getBase(): Internal.Ingredient;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble($$0: net.minecraft.world.Container_, $$1: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches($$0: net.minecraft.world.Container_, $$1: Internal.Level_): boolean;
        getAddition(): Internal.Ingredient;
        getMod(): string;
        getRemainingItems($$0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem($$0: Internal.RegistryAccess_): Internal.ItemStack;
        canCraftInDimensions($$0: number, $$1: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getResult(): Internal.ItemStack;
        isTemplateIngredient($$0: Internal.ItemStack_): boolean;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        isAdditionIngredient($$0: Internal.ItemStack_): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get template(): Internal.Ingredient
        get base(): Internal.Ingredient
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get addition(): Internal.Ingredient
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get result(): Internal.ItemStack
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        readonly addition: Internal.Ingredient;
        readonly template: Internal.Ingredient;
        readonly base: Internal.Ingredient;
    }
    type SmithingTransformRecipe_ = SmithingTransformRecipe;
    class MeltingFuel$Serializer extends Internal.LoggingRecipeSerializer<Internal.MeltingFuel> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): Internal.MeltingFuel;
    }
    type MeltingFuel$Serializer_ = MeltingFuel$Serializer;
    abstract class CustomLoaderBuilder <T extends Internal.ModelBuilder<T>> {
        visibility(partName: string, show: boolean): this;
        toJson(json: Internal.JsonObject_): Internal.JsonObject;
        end(): T;
    }
    type CustomLoaderBuilder_<T extends Internal.ModelBuilder<T>> = CustomLoaderBuilder<T>;
    abstract class AbstractShaftBlock extends Internal.RotatedPillarKineticBlock implements Internal.ProperWaterloggedBlock, Internal.IBE<Internal.KineticBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.KineticBlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.KineticBlockEntity>): void;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getBlockEntityClass(): typeof Internal.KineticBlockEntity;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.KineticBlockEntity>;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        abstract getBlockEntityType(): Internal.BlockEntityType<Internal.KineticBlockEntity>;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.KineticBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        showCapacityWithAnnotation(): boolean;
        emi(amount: number): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockEntityClass(): typeof Internal.KineticBlockEntity
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        get blockEntityType(): Internal.BlockEntityType<Internal.KineticBlockEntity>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
    }
    type AbstractShaftBlock_ = AbstractShaftBlock;
    interface Compressable extends Internal.Keyable {
        abstract compressor<T>(arg0: Internal.DynamicOps_<T>): Internal.KeyCompressor<T>;
        abstract keys<T>(arg0: Internal.DynamicOps_<T>): Internal.Stream<T>;
        forStrings(arg0: Internal.Supplier_<Internal.Stream<string>>): Internal.Keyable;
    }
    type Compressable_ = Compressable;
    class FrozenPigment extends Internal.Record {
        constructor(item: Internal.ItemStack_, owner: Internal.UUID_)
        serializeToNBT(): Internal.CompoundTag;
        getColorProvider(): Internal.ColorProvider;
        owner(): Internal.UUID;
        static fromNBT(tag: Internal.CompoundTag_): Internal.FrozenPigment;
        item(): Internal.ItemStack;
        get colorProvider(): Internal.ColorProvider
        static readonly ANCIENT: Internal.Supplier<Internal.FrozenPigment>;
        static readonly TAG_STACK: "stack";
        static readonly DEFAULT: Internal.Supplier<Internal.FrozenPigment>;
        static readonly TAG_OWNER: "owner";
    }
    type FrozenPigment_ = FrozenPigment;
    class ModelBakery implements Internal.ModelBakeryAccessor, Internal.ModelLoaderHooks {
        constructor($$0: Internal.BlockColors_, $$1: Internal.ProfilerFiller_, $$2: Internal.Map_<ResourceLocation, Internal.BlockModel>, $$3: Internal.Map_<ResourceLocation, Internal.List<any>>)
        fabric_getDispatcher(): Internal.ModelLoadingEventDispatcher;
        fabric_queueModelDependencies(model: Internal.UnbakedModel_): void;
        fabric_loadModelFromJson(id: ResourceLocation_): Internal.BlockModel;
        getBakedTopLevelModels(): Internal.Map<ResourceLocation, Internal.BakedModel>;
        fabric_putModel(id: ResourceLocation_, model: Internal.UnbakedModel_): void;
        handler$hcm000$resourcechickens$loadModelFromJson(id: ResourceLocation_, cir: Internal.CallbackInfoReturnable_<any>): void;
        fabric_getOrLoadModel(id: ResourceLocation_): Internal.UnbakedModel;
        getModelGroups(): Internal.Object2IntMap<Internal.BlockState>;
        loadTopLevel($$0: Internal.ModelResourceLocation_): void;
        fabric_putModelDirectly(id: ResourceLocation_, model: Internal.UnbakedModel_): void;
        handler$zfm000$porting_lib_base$onModelLoad(colors: Internal.BlockColors_, profiler: Internal.ProfilerFiller_, modelResources: Internal.Map_<any, any>, blockStateResources: Internal.Map_<any, any>, ci: Internal.CallbackInfo_): void;
        static port_lib$predicate$porting_lib_accessors_$md$fca01f$0(arg0: Internal.StateDefinition_<any, any>, arg1: string): Internal.Predicate<any>;
        bakeModels($$0: Internal.BiFunction_<ResourceLocation, Internal.Material, Internal.TextureAtlasSprite>): void;
        static port_lib$predicate(container: Internal.StateDefinition_<Internal.Block, Internal.BlockState>, variant: string): Internal.Predicate<Internal.BlockState>;
        fabric_getMissingModel(): Internal.UnbakedModel;
        getModel($$0: ResourceLocation_): Internal.UnbakedModel;
        get bakedTopLevelModels(): Internal.Map<ResourceLocation, Internal.BakedModel>
        get modelGroups(): Internal.Object2IntMap<Internal.BlockState>
        static readonly MISSING_MODEL_LOCATION: Internal.ModelResourceLocation;
        static readonly BANNER_BASE: Internal.Material;
        static readonly LAVA_FLOW: Internal.Material;
        static readonly WATER_FLOW: Internal.Material;
        static readonly ITEM_MODEL_GENERATOR: Internal.ItemModelGenerator;
        readonly topLevelModels: Internal.Map<ResourceLocation, Internal.UnbakedModel>;
        readonly bakedCache: Internal.Map<Internal.ModelBakery$BakedCacheKey, Internal.BakedModel>;
        static readonly MISSING_MODEL_MESH: "{    \"textures\": {       \"particle\": \"missingno\",       \"missingno\": \"missingno\"    },    \"elements\": [         {  \"from\": [ 0, 0, 0 ],            \"to\": [ 16, 16, 16 ],            \"faces\": {                \"down\":  { \"uv\": [ 0, 0, 16, 16 ], \"cullface\": \"down\",  \"texture\": \"#missingno\" },                \"up\":    { \"uv\": [ 0, 0, 16, 16 ], \"cullface\": \"up\",    \"texture\": \"#missingno\" },                \"north\": { \"uv\": [ 0, 0, 16, 16 ], \"cullface\": \"north\", \"texture\": \"#missingno\" },                \"south\": { \"uv\": [ 0, 0, 16, 16 ], \"cullface\": \"south\", \"texture\": \"#missingno\" },                \"west\":  { \"uv\": [ 0, 0, 16, 16 ], \"cullface\": \"west\",  \"texture\": \"#missingno\" },                \"east\":  { \"uv\": [ 0, 0, 16, 16 ], \"cullface\": \"east\",  \"texture\": \"#missingno\" }            }        }    ]}";
        static readonly WATER_OVERLAY: Internal.Material;
        static readonly MODEL_LISTER: Internal.FileToIdConverter;
        static readonly GENERATION_MARKER: Internal.BlockModel;
        static readonly BLOCK_ENTITY_MARKER: Internal.BlockModel;
        static readonly NO_PATTERN_SHIELD: Internal.Material;
        static readonly BLOCKSTATE_LISTER: Internal.FileToIdConverter;
        static readonly DESTROY_TYPES: [Internal.RenderType$CompositeRenderType, Internal.RenderType$CompositeRenderType, Internal.RenderType$CompositeRenderType, Internal.RenderType$CompositeRenderType, Internal.RenderType$CompositeRenderType, Internal.RenderType$CompositeRenderType, Internal.RenderType$CompositeRenderType, Internal.RenderType$CompositeRenderType, Internal.RenderType$CompositeRenderType, Internal.RenderType$CompositeRenderType];
        static readonly BREAKING_LOCATIONS: [ResourceLocation, ResourceLocation, ResourceLocation, ResourceLocation, ResourceLocation, ResourceLocation, ResourceLocation, ResourceLocation, ResourceLocation, ResourceLocation];
        static readonly DESTROY_STAGES: [ResourceLocation, ResourceLocation, ResourceLocation, ResourceLocation, ResourceLocation, ResourceLocation, ResourceLocation, ResourceLocation, ResourceLocation, ResourceLocation];
        static readonly SHIELD_BASE: Internal.Material;
        static readonly FIRE_1: Internal.Material;
        static readonly FIRE_0: Internal.Material;
        static readonly DESTROY_STAGE_COUNT: 10;
    }
    type ModelBakery_ = ModelBakery;
    class DecoratedPotBlockEntity$Decorations extends Internal.Record {
        constructor($$0: Internal.Item_, $$1: Internal.Item_, $$2: Internal.Item_, $$3: Internal.Item_)
        left(): Internal.Item;
        sorted(): Internal.Stream<Internal.Item>;
        front(): Internal.Item;
        static load($$0: Internal.CompoundTag_): Internal.DecoratedPotBlockEntity$Decorations;
        back(): Internal.Item;
        save($$0: Internal.CompoundTag_): Internal.CompoundTag;
        right(): Internal.Item;
        static readonly EMPTY: Internal.DecoratedPotBlockEntity$Decorations;
    }
    type DecoratedPotBlockEntity$Decorations_ = DecoratedPotBlockEntity$Decorations;
    class ChromaticCompoundItem extends Internal.Item implements Internal.EntityTickListenerItem, Internal.CustomMaxCountItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        onEntityItemUpdate(stack: Internal.ItemStack_, entity: Internal.ItemEntity_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getItemStackLimit(stack: Internal.ItemStack_): number;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        checkLight(stack: Internal.ItemStack_, entity: Internal.ItemEntity_, world: Internal.Level_, itemData: Internal.CompoundTag_, positionVec: Vec3d_, randomOffset: BlockPos_, state: Internal.BlockState_): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getLight(stack: Internal.ItemStack_): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ChromaticCompoundItem_ = ChromaticCompoundItem;
    class EnchantmentBuilder extends Internal.BuilderBase<Internal.Enchantment> {
        constructor(i: ResourceLocation_)
        rare(): this;
        canEnchant(i: Internal.Object2BooleanFunction_<Internal.ItemStack>): this;
        createObject(): any;
        damageProtection(i: Internal.EnchantmentBuilder$DamageProtectionFunction_): this;
        maxLevel(i: number): this;
        veryRare(): this;
        postAttack(i: Internal.EnchantmentBuilder$PostFunction_): this;
        checkCompatibility(i: Internal.Object2BooleanFunction_<ResourceLocation>): this;
        rarity(r: Internal.Enchantment$Rarity_): this;
        minLevel(i: number): this;
        maxCost(i: Internal.Int2IntFunction_): this;
        category(c: Internal.EnchantmentCategory_): this;
        minCost(i: Internal.Int2IntFunction_): this;
        postHurt(i: Internal.EnchantmentBuilder$PostFunction_): this;
        vanishable(): this;
        trident(): this;
        crossbow(): this;
        slots(s: Internal.EquipmentSlot_[]): this;
        uncommon(): this;
        curse(): this;
        undiscoverable(): this;
        armorLegs(): this;
        armorFeet(): this;
        treasureOnly(): this;
        armorChest(): this;
        untradeable(): this;
        damageBonus(i: Internal.EnchantmentBuilder$DamageBonusFunction_): this;
        weapon(): this;
        bow(): this;
        breakable(): this;
        armorHead(): this;
        fishingRod(): this;
        armor(): this;
        wearable(): this;
    }
    type EnchantmentBuilder_ = EnchantmentBuilder;
    interface FloatIterable extends Internal.Iterable<number> {
        forEach(arg0: Internal.FloatConsumer_): void;
        iterator(): Internal.Iterator<any>;
        spliterator(): Internal.Spliterator<any>;
        doubleSpliterator(): Internal.DoubleSpliterator;
        forEach(arg0: Internal.DoubleConsumer_): void;
        doubleIterator(): Internal.DoubleIterator;
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<number>): void;
    }
    type FloatIterable_ = FloatIterable;
    interface IInteractionChecker {
        abstract canPlayerUse(arg0: Internal.Player_): boolean;
        (arg0: Internal.Player): boolean;
    }
    type IInteractionChecker_ = IInteractionChecker;
    abstract class VolatileImage extends Internal.Image implements Internal.Transparency {
        abstract createGraphics(): Internal.Graphics2D;
        abstract getSnapshot(): Internal.BufferedImage;
        abstract getWidth(): number;
        getTransparency(): number;
        abstract getHeight(): number;
        abstract contentsLost(): boolean;
        abstract getCapabilities(): Internal.ImageCapabilities;
        abstract validate(arg0: Internal.GraphicsConfiguration_): number;
        get snapshot(): Internal.BufferedImage
        get width(): number
        get transparency(): number
        get height(): number
        get capabilities(): Internal.ImageCapabilities
        static readonly IMAGE_INCOMPATIBLE: 2;
        static readonly IMAGE_OK: 0;
        static readonly IMAGE_RESTORED: 1;
    }
    type VolatileImage_ = VolatileImage;
    interface Principal {
        abstract hashCode(): number;
        abstract toString(): string;
        abstract getName(): string;
        abstract equals(arg0: any): boolean;
        implies(arg0: Internal.Subject_): boolean;
        get name(): string
    }
    type Principal_ = Principal;
    abstract class Graphics {
        abstract clearRect(arg0: number, arg1: number, arg2: number, arg3: number): void;
        abstract setFont(arg0: Internal.Font_): void;
        abstract drawLine(arg0: number, arg1: number, arg2: number, arg3: number): void;
        abstract fillRect(arg0: number, arg1: number, arg2: number, arg3: number): void;
        abstract drawImage(arg0: Internal.Image_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Internal.ImageObserver_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        finalize(): void;
        abstract drawRoundRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): void;
        getFontMetrics(): Internal.FontMetrics;
        abstract fillOval(arg0: number, arg1: number, arg2: number, arg3: number): void;
        drawPolygon(arg0: Internal.Polygon_): void;
        abstract drawString(arg0: string, arg1: number, arg2: number): void;
        abstract fillArc(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): void;
        abstract getClip(): Internal.Shape;
        getClipBounds(arg0: Internal.Rectangle_): Internal.Rectangle;
        abstract fillRoundRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): void;
        abstract translate(arg0: number, arg1: number): void;
        abstract drawOval(arg0: number, arg1: number, arg2: number, arg3: number): void;
        fillPolygon(arg0: Internal.Polygon_): void;
        abstract drawArc(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): void;
        abstract setClip(arg0: number, arg1: number, arg2: number, arg3: number): void;
        abstract dispose(): void;
        abstract getClipBounds(): Internal.Rectangle;
        drawBytes(arg0: number[], arg1: number, arg2: number, arg3: number, arg4: number): void;
        abstract copyArea(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): void;
        abstract drawImage(arg0: Internal.Image_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Internal.Color_, arg6: Internal.ImageObserver_): boolean;
        abstract getFont(): Internal.Font;
        abstract drawString(arg0: Internal.AttributedCharacterIterator_, arg1: number, arg2: number): void;
        abstract getFontMetrics(arg0: Internal.Font_): Internal.FontMetrics;
        abstract drawImage(arg0: Internal.Image_, arg1: number, arg2: number, arg3: Internal.ImageObserver_): boolean;
        draw3DRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): void;
        abstract clipRect(arg0: number, arg1: number, arg2: number, arg3: number): void;
        abstract setClip(arg0: Internal.Shape_): void;
        abstract drawImage(arg0: Internal.Image_, arg1: number, arg2: number, arg3: Internal.Color_, arg4: Internal.ImageObserver_): boolean;
        abstract setXORMode(arg0: Internal.Color_): void;
        /**
         * @deprecated
        */
        getClipRect(): Internal.Rectangle;
        abstract create(): this;
        abstract setColor(arg0: Internal.Color_): void;
        drawChars(arg0: string[], arg1: number, arg2: number, arg3: number, arg4: number): void;
        hitClip(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        fill3DRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): void;
        abstract fillPolygon(arg0: number[], arg1: number[], arg2: number): void;
        abstract drawImage(arg0: Internal.Image_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Internal.ImageObserver_): boolean;
        abstract drawImage(arg0: Internal.Image_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Internal.Color_, arg10: Internal.ImageObserver_): boolean;
        abstract drawPolyline(arg0: number[], arg1: number[], arg2: number): void;
        drawRect(arg0: number, arg1: number, arg2: number, arg3: number): void;
        abstract setPaintMode(): void;
        abstract getColor(): Internal.Color;
        create(arg0: number, arg1: number, arg2: number, arg3: number): this;
        abstract drawPolygon(arg0: number[], arg1: number[], arg2: number): void;
        set font(arg0: Internal.Font_)
        get fontMetrics(): Internal.FontMetrics
        get clip(): Internal.Shape
        get clipBounds(): Internal.Rectangle
        get font(): Internal.Font
        set clip(arg0: Internal.Shape_)
        set XORMode(arg0: Internal.Color_)
        /**
         * @deprecated
        */
        get clipRect(): Internal.Rectangle
        set color(arg0: Internal.Color_)
        get color(): Internal.Color
    }
    type Graphics_ = Graphics;
    class MinecartCouplingItem extends Internal.Item {
        constructor(p_i48487_1_: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static handleInteractionWithMinecart(player: Internal.Player_, world: Internal.Level_, hand: Internal.InteractionHand_, interacted: Internal.Entity_, hitResult: Internal.EntityHitResult_): Internal.InteractionResult;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type MinecartCouplingItem_ = MinecartCouplingItem;
    class FluidComponents$2 implements Internal.RecipeComponent<Internal.OutputFluid> {
        asArray(): Internal.ArrayRecipeComponent<Internal.OutputFluid>;
        readFromJson(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<Internal.OutputFluid>, json: Internal.JsonObject_): void;
        write(arg0: Internal.RecipeJS_, arg1: any): Internal.JsonElement;
        isOutput(recipe: Internal.RecipeJS_, value: Internal.OutputFluid_, match: Internal.ReplacementMatch_): boolean;
        role(): Internal.ComponentRole;
        componentClass(): typeof any;
        replaceOutput(recipe: Internal.RecipeJS_, original: Internal.OutputFluid_, match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): Internal.OutputFluid;
        checkValueHasChanged(oldValue: Internal.OutputFluid_, newValue: Internal.OutputFluid_): boolean;
        write(recipe: Internal.RecipeJS_, value: Internal.OutputFluid_): Internal.JsonElement;
        constructorDescription(ctx: Internal.DescriptionContext_): Internal.TypeDescJS;
        read(recipe: Internal.RecipeJS_, from: any): Internal.OutputFluid;
        asPatternKey(): Internal.RecipeComponent<Internal.TinyMap<string, Internal.OutputFluid>>;
        componentType(): string;
        or<O>(other: Internal.RecipeComponent_<O>): Internal.OrRecipeComponent<Internal.OutputFluid, O>;
        checkEmpty(arg0: Internal.RecipeKey_<any>, arg1: any): string;
        /**
         * Returns a new RecipeComponent that applies the mappingTo function to the input before it is passed to this component to be read, and the mappingFrom function after the component writes to json, before that json is saved
        */
        map(mappingTo: Internal.UnaryOperator_<any>, mappingFrom: Internal.UnaryOperator_<Internal.JsonElement>): Internal.MappingRecipeComponent<Internal.OutputFluid>;
        static builder(): Internal.RecipeComponentBuilder;
        isInput(recipe: Internal.RecipeJS_, value: Internal.OutputFluid_, match: Internal.ReplacementMatch_): boolean;
        hasPriority(recipe: Internal.RecipeJS_, from: any): boolean;
        readFromMap(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<Internal.OutputFluid>, map: Internal.Map_<any, any>): void;
        writeToJson(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<Internal.OutputFluid>, json: Internal.JsonObject_): void;
        checkEmpty(key: Internal.RecipeKey_<Internal.OutputFluid>, value: Internal.OutputFluid_): string;
        /**
         * Returns a new RecipeComponent that maps the keys in a JsonObject according to the provided map, both before the json gets passed to the component and after the component returns a written json object.
         * The mappings should be provided in the format `{recipe: "component"}` where recipe is the key as in the recipe, and component is the key as how the RecipeComponent expects it.
         * Any keys not included in the provided map will be ignored, and any keys in the provided map that are not in either the input object or output object will be ignored.
         * Note that if the input or output is not a JsonObject (ie its an ItemStack, or it is a JsonPrimitive) then that will pass through this without being modified.
         * If you wish to handle those situations use the actual map function
        */
        simpleMap(mappings: any): Internal.SimpleMappingRecipeComponent<Internal.OutputFluid>;
        static builder(...key: Internal.RecipeKey_<any>[]): Internal.RecipeComponentBuilder;
        asArrayOrSelf(): Internal.ArrayRecipeComponent<Internal.OutputFluid>;
        key(name: string): Internal.RecipeKey<Internal.OutputFluid>;
        asMap<K>(key: Internal.RecipeComponent_<K>): Internal.RecipeComponent<Internal.TinyMap<K, Internal.OutputFluid>>;
        isOutput(arg0: Internal.RecipeJS_, arg1: any, arg2: Internal.ReplacementMatch_): boolean;
        /**
         * Returns a new RecipeComponent that applies the mappingTo function to the input before it is passed to this component to be read
        */
        mapIn(mappingTo: Internal.UnaryOperator_<any>): Internal.MappingRecipeComponent<Internal.OutputFluid>;
        orSelf(): Internal.RecipeComponent<Internal.OutputFluid>;
        /**
         * Returns a new RecipeComponent that applies the mappingFrom function after the component writes to json, before that json is saved
        */
        mapOut(mappingFrom: Internal.UnaryOperator_<Internal.JsonElement>): Internal.MappingRecipeComponent<Internal.OutputFluid>;
        and<O>(other: Internal.RecipeComponent_<O>): Internal.AndRecipeComponent<Internal.OutputFluid, O>;
        replaceInput(recipe: Internal.RecipeJS_, original: Internal.OutputFluid_, match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): Internal.OutputFluid;
    }
    type FluidComponents$2_ = FluidComponents$2;
    class FluidType {
        constructor(properties: any_)
        canSwim(entity: Internal.Entity_): boolean;
        canBePlacedInLevel(getter: Internal.BlockAndTintGetter_, pos: BlockPos_, state: Internal.FluidState_): boolean;
        isVaporizedOnPlacement(level: Internal.Level_, pos: BlockPos_, stack: Internal.FluidStack_): boolean;
        getLightLevel(state: Internal.FluidState_, getter: Internal.BlockAndTintGetter_, pos: BlockPos_): number;
        getDensity(state: Internal.FluidState_, getter: Internal.BlockAndTintGetter_, pos: BlockPos_): number;
        canExtinguish(entity: Internal.Entity_): boolean;
        getTemperature(stack: Internal.FluidStack_): number;
        getDensity(): number;
        getDescriptionId(): string;
        getStateForPlacement(getter: Internal.BlockAndTintGetter_, pos: BlockPos_, stack: Internal.FluidStack_): Internal.FluidState;
        getRarity(): Internal.Rarity;
        getBucket(stack: Internal.FluidStack_): Internal.ItemStack;
        getFallDistanceModifier(entity: Internal.Entity_): number;
        getBlockForFluidState(getter: Internal.BlockAndTintGetter_, pos: BlockPos_, state: Internal.FluidState_): Internal.BlockState;
        getAdjacentBlockPathType(state: Internal.FluidState_, level: Internal.BlockGetter_, pos: BlockPos_, mob: Internal.Mob_, originalType: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        canHydrate(state: Internal.FluidState_, getter: Internal.BlockGetter_, pos: BlockPos_, source: Internal.BlockState_, sourcePos: BlockPos_): boolean;
        getTemperature(): number;
        supportsBoating(state: Internal.FluidState_, boat: Internal.Boat_): boolean;
        canBePlacedInLevel(getter: Internal.BlockAndTintGetter_, pos: BlockPos_, stack: Internal.FluidStack_): boolean;
        getDescription(): net.minecraft.network.chat.Component;
        getViscosity(): number;
        getDescriptionId(stack: Internal.FluidStack_): string;
        getRarity(stack: Internal.FluidStack_): Internal.Rarity;
        isVanilla(): boolean;
        motionScale(entity: Internal.Entity_): number;
        getSound(player: Internal.Player_, getter: Internal.BlockGetter_, pos: BlockPos_, action: Internal.SoundAction_): Internal.SoundEvent;
        getRenderPropertiesInternal(): any;
        isAir(): boolean;
        canDrownIn(entity: Internal.LivingEntity_): boolean;
        onVaporize(player: Internal.Player_, level: Internal.Level_, pos: BlockPos_, stack: Internal.FluidStack_): void;
        getLightLevel(stack: Internal.FluidStack_): number;
        canPushEntity(entity: Internal.Entity_): boolean;
        getSound(action: Internal.SoundAction_): Internal.SoundEvent;
        getSound(entity: Internal.Entity_, action: Internal.SoundAction_): Internal.SoundEvent;
        getDescription(stack: Internal.FluidStack_): net.minecraft.network.chat.Component;
        getViscosity(stack: Internal.FluidStack_): number;
        isLighterThanAir(): boolean;
        canHydrate(entity: Internal.Entity_): boolean;
        canRideVehicleUnder(vehicle: Internal.Entity_, rider: Internal.Entity_): boolean;
        supportsBoating(boat: Internal.Boat_): boolean;
        getLightLevel(): number;
        getBlockPathType(state: Internal.FluidState_, level: Internal.BlockGetter_, pos: BlockPos_, mob: Internal.Mob_, canFluidLog: boolean): Internal.BlockPathTypes;
        setItemMovement(entity: Internal.ItemEntity_): void;
        move(state: Internal.FluidState_, entity: Internal.LivingEntity_, movementVector: Vec3d_, gravity: number): boolean;
        canExtinguish(state: Internal.FluidState_, getter: Internal.BlockGetter_, pos: BlockPos_): boolean;
        canConvertToSource(state: Internal.FluidState_, reader: Internal.LevelReader_, pos: BlockPos_): boolean;
        getDensity(stack: Internal.FluidStack_): number;
        canConvertToSource(stack: Internal.FluidStack_): boolean;
        getTemperature(state: Internal.FluidState_, getter: Internal.BlockAndTintGetter_, pos: BlockPos_): number;
        getViscosity(state: Internal.FluidState_, getter: Internal.BlockAndTintGetter_, pos: BlockPos_): number;
        getSound(stack: Internal.FluidStack_, action: Internal.SoundAction_): Internal.SoundEvent;
        canHydrate(stack: Internal.FluidStack_): boolean;
        get density(): number
        get descriptionId(): string
        get rarity(): Internal.Rarity
        get temperature(): number
        get description(): net.minecraft.network.chat.Component
        get viscosity(): number
        get vanilla(): boolean
        get renderPropertiesInternal(): any
        get air(): boolean
        get lighterThanAir(): boolean
        get lightLevel(): number
        set itemMovement(entity: Internal.ItemEntity_)
    }
    type FluidType_ = FluidType | Special.FluidType;
    class MoltenBrassFluid$Source extends Internal.MoltenBrassFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenBrassFluid$Source_ = MoltenBrassFluid$Source;
    interface InventoryIdentifier {
        get(level: Internal.Level_, face: Internal.BlockFace_): this;
        abstract contains(arg0: Internal.BlockFace_): boolean;
        (arg0: Internal.BlockFace): boolean;
        readonly REGISTRY: Internal.SimpleRegistry<Internal.Block, Internal.InventoryIdentifier$Finder>;
    }
    type InventoryIdentifier_ = InventoryIdentifier;
    class RandomSpreadType extends Internal.Enum<Internal.RandomSpreadType> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        evaluate($$0: Internal.RandomSource_, $$1: number): number;
        static valueOf($$0: string): Internal.RandomSpreadType;
        getSerializedName(): string;
        static values(): Internal.RandomSpreadType[];
        get serializedName(): string
        static readonly LINEAR: Internal.RandomSpreadType;
        static readonly TRIANGULAR: Internal.RandomSpreadType;
        static readonly CODEC: Internal.Codec<Internal.RandomSpreadType>;
    }
    type RandomSpreadType_ = "linear" | RandomSpreadType | "triangular";
    interface ConditionUserBuilder <T extends Internal.ConditionUserBuilder<T>> {
        when<E>($$0: Internal.Iterable_<E>, $$1: Internal.Function_<E, Internal.LootItemCondition$Builder>): T;
        abstract when(arg0: Internal.LootItemCondition$Builder_): T;
        abstract unwrap(): T;
    }
    type ConditionUserBuilder_<T extends Internal.ConditionUserBuilder<T>> = ConditionUserBuilder<T>;
    class TerrainAdjustment extends Internal.Enum<Internal.TerrainAdjustment> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static valueOf($$0: string): Internal.TerrainAdjustment;
        getSerializedName(): string;
        static values(): Internal.TerrainAdjustment[];
        get serializedName(): string
        static readonly BEARD_BOX: Internal.TerrainAdjustment;
        static readonly NONE: Internal.TerrainAdjustment;
        static readonly CODEC: Internal.Codec<Internal.TerrainAdjustment>;
        static readonly BURY: Internal.TerrainAdjustment;
        static readonly BEARD_THIN: Internal.TerrainAdjustment;
    }
    type TerrainAdjustment_ = TerrainAdjustment | "bury" | "beard_thin" | "beard_box" | "none";
    class BusSupport extends Internal.Enum<Internal.BusSupport> {
        static valueOf(name: string): Internal.BusSupport;
        static values(): Internal.BusSupport[];
        static readonly DENSE_CABLE: Internal.BusSupport;
        static readonly CABLE: Internal.BusSupport;
    }
    type BusSupport_ = BusSupport | "dense_cable" | "cable";
    interface StencilElement extends Internal.RenderElement {
        abstract at<T extends Internal.RenderElement>(arg0: number, arg1: number, arg2: number): T;
        abstract getX(): number;
        abstract getZ(): number;
        abstract getWidth(): number;
        abstract withBounds<T extends Internal.RenderElement>(arg0: number, arg1: number): T;
        abstract getY(): number;
        render(graphics: Internal.GuiGraphics_, x: number, y: number): void;
        abstract renderStencil(arg0: Internal.GuiGraphics_): void;
        render(graphics: Internal.GuiGraphics_): void;
        abstract withAlpha<T extends Internal.RenderElement>(arg0: number): T;
        prepareStencil(graphics: Internal.GuiGraphics_): void;
        transform(graphics: Internal.GuiGraphics_): void;
        prepareElement(graphics: Internal.GuiGraphics_): void;
        abstract at<T extends Internal.RenderElement>(arg0: number, arg1: number): T;
        abstract renderElement(arg0: Internal.GuiGraphics_): void;
        render(graphics: Internal.GuiGraphics_, x: number, y: number, alpha: number): void;
        abstract getHeight(): number;
        cleanUp(graphics: Internal.GuiGraphics_): void;
        of(renderable: Internal.ScreenElement_): Internal.RenderElement;
        get x(): number
        get z(): number
        get width(): number
        get y(): number
        get height(): number
    }
    type StencilElement_ = StencilElement;
    interface IDeadMob {
        abstract isMobDead(): boolean;
        get mobDead(): boolean
        (): boolean;
    }
    type IDeadMob_ = IDeadMob;
    class MoltenMetalFluid extends Internal.ModFlowingFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        method_15776(level: Internal.Level_, pos: BlockPos_, state: Internal.FluidState_, random: Internal.RandomSource_): void;
        method_15792(level: Internal.Level_, pos: BlockPos_, state: Internal.FluidState_, random: Internal.RandomSource_): void;
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenMetalFluid_ = MoltenMetalFluid;
    class BlockIDPredicate implements Internal.BlockPredicate {
        constructor(i: ResourceLocation_)
        "with"(key: string, value: string): this;
        checkState(state: Internal.BlockState_): boolean;
        check(b: Internal.BlockContainerJS_): boolean;
        getBlockState(): Internal.BlockState;
        getBlockProperties(): Internal.List<Internal.BlockIDPredicate$PropertyObject>;
        get blockState(): Internal.BlockState
        get blockProperties(): Internal.List<Internal.BlockIDPredicate$PropertyObject>
    }
    type BlockIDPredicate_ = BlockIDPredicate;
    class CreativeCrateMountedStorageType extends Internal.MountedItemStorageType<Internal.CreativeCrateMountedStorage> {
        constructor()
        mount(level: Internal.Level_, state: Internal.BlockState_, pos: BlockPos_, be: Internal.BlockEntity_): Internal.CreativeCrateMountedStorage;
    }
    type CreativeCrateMountedStorageType_ = CreativeCrateMountedStorageType;
    class WebbingFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type WebbingFeature_ = WebbingFeature;
    interface EnchantmentBuilder$EnchantmentFactory <T extends Internal.Enchantment> {
        abstract create(arg0: Internal.Enchantment$Rarity_, arg1: Internal.EnchantmentCategory_, ...arg2: Internal.EquipmentSlot_[]): T;
        (arg0: Internal.Enchantment$Rarity, arg1: Internal.EnchantmentCategory, ...arg2: Internal.EquipmentSlot[]): T;
    }
    type EnchantmentBuilder$EnchantmentFactory_<T extends Internal.Enchantment> = EnchantmentBuilder$EnchantmentFactory<T>;
    class LecternBlock extends Internal.BaseEntityBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        static resetBookState($$0: Internal.Entity_, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.BlockState_, $$4: boolean): void;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static tryPlaceBook($$0: Internal.Entity_, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.BlockState_, $$4: Internal.ItemStack_): boolean;
        emi(): Internal.EmiStack;
        static signalPageChange($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_): void;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly SHAPE_NORTH: Internal.ArrayVoxelShape;
        static readonly SHAPE_BASE: Internal.VoxelShapeAlignedCuboid;
        static readonly SHAPE_COLLISION: Internal.CubeVoxelShape;
        static readonly SHAPE_TOP_PLATE: Internal.VoxelShapeEmpty;
        static readonly SHAPE_SOUTH: Internal.ArrayVoxelShape;
        static readonly HAS_BOOK: Internal.BooleanProperty;
        static readonly SHAPE_WEST: Internal.ArrayVoxelShape;
        static readonly SHAPE_EAST: Internal.ArrayVoxelShape;
        static readonly SHAPE_POST: Internal.VoxelShapeAlignedCuboid;
        static readonly FACING: Internal.DirectionProperty;
        static readonly SHAPE_COMMON: Internal.CubeVoxelShape;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type LecternBlock_ = LecternBlock;
    class InstantenousMobEffect extends Internal.MobEffect {
        constructor($$0: Internal.MobEffectCategory_, $$1: number)
        getCurativeItems(): Internal.List<Internal.ItemStack>;
        getSortOrder(potionEffect: Internal.MobEffectInstance_): number;
        getRenderer(): Internal.MobEffectRenderer;
        get curativeItems(): Internal.List<Internal.ItemStack>
        get renderer(): Internal.MobEffectRenderer
    }
    type InstantenousMobEffect_ = InstantenousMobEffect;
    class ClientboundCustomPayloadPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: ResourceLocation_, $$1: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.FriendlyByteBuf_)
        getData(): Internal.FriendlyByteBuf;
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getIdentifier(): ResourceLocation;
        isSkippable(): boolean;
        get data(): Internal.FriendlyByteBuf
        get identifier(): ResourceLocation
        get skippable(): boolean
        static readonly DEBUG_POI_REMOVED_PACKET: ResourceLocation;
        static readonly DEBUG_RAIDS: ResourceLocation;
        static readonly DEBUG_POI_TICKET_COUNT_PACKET: ResourceLocation;
        static readonly DEBUG_HIVE: ResourceLocation;
        static readonly DEBUG_NEIGHBORSUPDATE_PACKET: ResourceLocation;
        static readonly DEBUG_STRUCTURES_PACKET: ResourceLocation;
        static readonly DEBUG_BRAIN: ResourceLocation;
        static readonly DEBUG_VILLAGE_SECTIONS: ResourceLocation;
        static readonly DEBUG_PATHFINDING_PACKET: ResourceLocation;
        static readonly DEBUG_GAME_EVENT: ResourceLocation;
        static readonly DEBUG_GOAL_SELECTOR: ResourceLocation;
        static readonly BRAND: ResourceLocation;
        static readonly DEBUG_GAME_EVENT_LISTENER: ResourceLocation;
        static readonly DEBUG_WORLDGENATTEMPT_PACKET: ResourceLocation;
        static readonly DEBUG_BEE: ResourceLocation;
        static readonly DEBUG_POI_ADDED_PACKET: ResourceLocation;
        static readonly DEBUG_GAME_TEST_ADD_MARKER: ResourceLocation;
        static readonly DEBUG_GAME_TEST_CLEAR: ResourceLocation;
    }
    type ClientboundCustomPayloadPacket_ = ClientboundCustomPayloadPacket;
    class OutputReplacementTransformer$Replacement extends Internal.Record implements Internal.OutputReplacement {
        constructor(with_: Internal.OutputReplacement_, transformer: Internal.OutputReplacementTransformer_)
        replaceOutput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.OutputReplacement_): any;
        transform(transformer: Internal.OutputReplacementTransformer_): this;
        transformer(): Internal.OutputReplacementTransformer;
        static of(o: any): Internal.OutputReplacement;
        "with"(): Internal.OutputReplacement;
    }
    type OutputReplacementTransformer$Replacement_ = OutputReplacementTransformer$Replacement;
    class LayeredOreConfiguration implements Internal.FeatureConfiguration {
        constructor(layerPatterns: Internal.List_<Internal.LayerPattern>, size: number, discardChanceOnAirExposure: number)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.LayeredOreConfiguration>;
        readonly discardChanceOnAirExposure: number;
        readonly size: number;
        readonly layerPatterns: Internal.List<Internal.LayerPattern>;
    }
    type LayeredOreConfiguration_ = LayeredOreConfiguration;
    interface SoundManagerAccessor {
        abstract getEngine(): Internal.SoundEngine;
        get engine(): Internal.SoundEngine
        (): Internal.SoundEngine_;
    }
    type SoundManagerAccessor_ = SoundManagerAccessor;
    interface IHoldingPlayerExtension {
        abstract moonlight$setCustomMarkersDirty(): void;
        abstract moonlight$setCustomDataDirty<H extends Internal.CustomMapData$DirtyCounter>(arg0: Internal.CustomMapData$Type_<any>, arg1: Internal.Consumer_<H>): void;
    }
    type IHoldingPlayerExtension_ = IHoldingPlayerExtension;
    interface AgriGrowthResponse {
        priority(): number;
        isInstantKill(): boolean;
        onPlantKilled(crop: Internal.AgriCrop_): void;
        abstract isLethal(): boolean;
        abstract isFertile(): boolean;
        get instantKill(): boolean
        get lethal(): boolean
        get fertile(): boolean
        readonly KILL_IT_WITH_FIRE: Internal.AgriGrowthResponse;
        readonly FERTILE: Internal.AgriGrowthResponse;
        readonly LETHAL: Internal.AgriGrowthResponse;
        readonly INFERTILE: Internal.AgriGrowthResponse;
    }
    type AgriGrowthResponse_ = AgriGrowthResponse;
    class StoveBlock extends Internal.BaseEntityBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getBlockPathType(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, entity: Internal.Mob_): Internal.BlockPathTypes;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        extinguish(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getBlockPathType(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_): Internal.BlockPathTypes;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly LIT: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type StoveBlock_ = StoveBlock;
    class Sensing {
        constructor($$0: Internal.Mob_)
        hasLineOfSight($$0: Internal.Entity_): boolean;
        tick(): void;
    }
    type Sensing_ = Sensing;
    class StructureSpawnOverride extends Internal.Record {
        constructor($$0: Internal.StructureSpawnOverride$BoundingBoxType_, $$1: Internal.WeightedRandomList_<Internal.MobSpawnSettings$SpawnerData>)
        boundingBox(): Internal.StructureSpawnOverride$BoundingBoxType;
        spawns(): Internal.WeightedRandomList<Internal.MobSpawnSettings$SpawnerData>;
        static readonly CODEC: Internal.Codec<Internal.StructureSpawnOverride>;
    }
    type StructureSpawnOverride_ = StructureSpawnOverride;
    class TidepoolFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type TidepoolFeature_ = TidepoolFeature;
    interface ParticleEngine$SpriteParticleRegistration <T extends Internal.ParticleOptions> {
        abstract create(arg0: Internal.SpriteSet_): Internal.ParticleProvider<T>;
        (arg0: Internal.SpriteSet): Internal.ParticleProvider_<T>;
    }
    type ParticleEngine$SpriteParticleRegistration_<T extends Internal.ParticleOptions> = ParticleEngine$SpriteParticleRegistration<T>;
    class ItemMenuHost implements Internal.IUpgradeableObject {
        constructor(player: Internal.Player_, slot: number, itemStack: Internal.ItemStack_)
        isUpgradedWith(upgradeCard: Internal.ItemLike_): boolean;
        getInstalledUpgrades(upgradeCard: Internal.ItemLike_): number;
        isClientSide(): boolean;
        drainPower(): boolean;
        getSlot(): number;
        getUpgrades(): Internal.IUpgradeInventory;
        getPlayer(): Internal.Player;
        onBroadcastChanges(menu: Internal.AbstractContainerMenu_): boolean;
        getItemStack(): Internal.ItemStack;
        get clientSide(): boolean
        get slot(): number
        get upgrades(): Internal.IUpgradeInventory
        get player(): Internal.Player
        get itemStack(): Internal.ItemStack
    }
    type ItemMenuHost_ = ItemMenuHost;
    class CarvingMask {
        constructor($$0: number, $$1: number)
        constructor($$0: number[], $$1: number)
        stream($$0: Internal.ChunkPos_): Internal.Stream<BlockPos>;
        setAdditionalMask($$0: Internal.CarvingMask$Mask_): void;
        set($$0: number, $$1: number, $$2: number): void;
        get($$0: number, $$1: number, $$2: number): boolean;
        toArray(): number[];
        set additionalMask($$0: Internal.CarvingMask$Mask_)
    }
    type CarvingMask_ = CarvingMask;
    class TimeUnit extends Internal.Enum<Internal.TimeUnit> {
        sleep(arg0: number): void;
        convert(arg0: number, arg1: Internal.TimeUnit_): number;
        static of(arg0: Internal.ChronoUnit_): Internal.TimeUnit;
        toMillis(arg0: number): number;
        toNanos(arg0: number): number;
        timedJoin(arg0: Internal.Thread_, arg1: number): void;
        toSeconds(arg0: number): number;
        toMinutes(arg0: number): number;
        timedWait(arg0: any, arg1: number): void;
        static values(): Internal.TimeUnit[];
        toMicros(arg0: number): number;
        convert(arg0: Duration_): number;
        static valueOf(arg0: string): Internal.TimeUnit;
        toChronoUnit(): Internal.ChronoUnit;
        toHours(arg0: number): number;
        toDays(arg0: number): number;
        static readonly MINUTES: Internal.TimeUnit;
        static readonly SECONDS: Internal.TimeUnit;
        static readonly DAYS: Internal.TimeUnit;
        static readonly NANOSECONDS: Internal.TimeUnit;
        static readonly MICROSECONDS: Internal.TimeUnit;
        static readonly MILLISECONDS: Internal.TimeUnit;
        static readonly HOURS: Internal.TimeUnit;
    }
    type TimeUnit_ = "nanoseconds" | "minutes" | "seconds" | TimeUnit | "days" | "hours" | "microseconds" | "milliseconds";
    interface IngredientSupplierKJS {
        kjs$asIngredient(): Internal.Ingredient;
    }
    type IngredientSupplierKJS_ = IngredientSupplierKJS;
    abstract class ClickToLinkBlockItem extends Internal.BlockItem implements Internal.BlockUseBypassingItem {
        constructor(pBlock: Internal.Block_, pProperties: Internal.Item$Properties_)
        abstract getMaxDistanceFromSelection(): number;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        getSelectionBounds(pos: BlockPos_): Internal.AABB;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        isValidTarget(level: Internal.LevelAccessor_, pos: BlockPos_): boolean;
        placeWhenInvalid(): boolean;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static clientTick(): void;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        abstract getMessageTranslationKey(): string;
        shouldBypass(state: Internal.BlockState_, pos: BlockPos_, level: Internal.Level_, player: Internal.Player_, hand: Internal.InteractionHand_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        get maxDistanceFromSelection(): number
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get messageTranslationKey(): string
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ClickToLinkBlockItem_ = ClickToLinkBlockItem;
    class CombustibleItem extends Internal.Item {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getBurnTime(itemStack: Internal.ItemStack_, recipeType: Internal.RecipeType_<any>): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        setBurnTime(burnTime: number): void;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        set burnTime(burnTime: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CombustibleItem_ = CombustibleItem;
    class BlockColors implements Internal.ColorProviderRegistryImpl$ColorMapperHolder<any, any>, Internal.BlockColorsExtended {
        constructor()
        getColor($$0: Internal.BlockState_, $$1: Internal.BlockAndTintGetter_, $$2: BlockPos_, $$3: number): number;
        static getProviders(blockColors: Internal.BlockColors_): Internal.Reference2ReferenceMap<Internal.Block, Internal.BlockColor>;
        getColor($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_): number;
        getColoringProperties($$0: Internal.Block_): Internal.Set<Internal.Property<any>>;
        sodium$getProviders(): Internal.Reference2ReferenceMap<any, any>;
        static getOverridenVanillaBlocks(blockColors: Internal.BlockColors_): Internal.ReferenceSet<Internal.Block>;
        register($$0: Internal.BlockColor_, ...$$1: Internal.Block_[]): void;
        static createDefault(): Internal.BlockColors;
        get(block: Internal.Block_): Internal.BlockColor;
        sodium$getOverridenVanillaBlocks(): Internal.ReferenceSet<any>;
        get(arg0: any): any;
    }
    type BlockColors_ = BlockColors;
    class HorseArmorItem extends Internal.Item {
        constructor($$0: number, $$1: string, $$2: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        getTexture(): ResourceLocation;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        getProtection(): number;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        get texture(): ResourceLocation
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get protection(): number
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly TEX_FOLDER: "textures/entity/horse/";
    }
    type HorseArmorItem_ = HorseArmorItem;
    class FrontAndTop extends Internal.Enum<Internal.FrontAndTop> implements Internal.StringRepresentable {
        static fromFrontAndTop($$0: Internal.Direction_, $$1: Internal.Direction_): Internal.FrontAndTop;
        front(): Internal.Direction;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static values(): Internal.FrontAndTop[];
        static valueOf($$0: string): Internal.FrontAndTop;
        top(): Internal.Direction;
        get serializedName(): string
        static readonly DOWN_SOUTH: Internal.FrontAndTop;
        static readonly DOWN_NORTH: Internal.FrontAndTop;
        static readonly DOWN_EAST: Internal.FrontAndTop;
        static readonly SOUTH_UP: Internal.FrontAndTop;
        static readonly NORTH_UP: Internal.FrontAndTop;
        static readonly UP_EAST: Internal.FrontAndTop;
        static readonly UP_NORTH: Internal.FrontAndTop;
        static readonly EAST_UP: Internal.FrontAndTop;
        static readonly DOWN_WEST: Internal.FrontAndTop;
        static readonly UP_WEST: Internal.FrontAndTop;
        static readonly UP_SOUTH: Internal.FrontAndTop;
        static readonly WEST_UP: Internal.FrontAndTop;
    }
    type FrontAndTop_ = "south_up" | "north_up" | FrontAndTop | "up_west" | "down_east" | "down_south" | "up_east" | "east_up" | "down_north" | "down_west" | "up_south" | "west_up" | "up_north";
    interface BufferVertexConsumer extends Internal.VertexConsumer {
        uv2($$0: number): Internal.VertexConsumer;
        color($$0: number, $$1: number, $$2: number, $$3: number): Internal.VertexConsumer;
        abstract endVertex(): void;
        color($$0: number): Internal.VertexConsumer;
        normalIntValue($$0: number): number;
        normal($$0: number, $$1: number, $$2: number): Internal.VertexConsumer;
        overlayCoords($$0: number): Internal.VertexConsumer;
        vertex($$0: number, $$1: number, $$2: number): Internal.VertexConsumer;
        color($$0: number, $$1: number, $$2: number, $$3: number): Internal.VertexConsumer;
        putBulkData($$0: Internal.PoseStack$Pose_, $$1: Internal.BakedQuad_, $$2: number[], $$3: number, $$4: number, $$5: number, $$6: number[], $$7: number, $$8: boolean): void;
        putBulkData($$0: Internal.PoseStack$Pose_, $$1: Internal.BakedQuad_, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number): void;
        abstract currentElement(): Internal.VertexFormatElement;
        overlayCoords($$0: number, $$1: number): Internal.VertexConsumer;
        abstract nextElement(): void;
        uvShort($$0: number, $$1: number, $$2: number): Internal.VertexConsumer;
        abstract putShort(arg0: number, arg1: number): void;
        abstract defaultColor(arg0: number, arg1: number, arg2: number, arg3: number): void;
        abstract putByte(arg0: number, arg1: number): void;
        uv2($$0: number, $$1: number): Internal.VertexConsumer;
        normal(matrix: Matrix3f_, x: number, y: number, z: number): Internal.VertexConsumer;
        abstract putFloat(arg0: number, arg1: number): void;
        vertex($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number, $$8: number, $$9: number, $$10: number, $$11: number, $$12: number, $$13: number): void;
        vertex(matrix: Matrix4f_, x: number, y: number, z: number): Internal.VertexConsumer;
        uv($$0: number, $$1: number): Internal.VertexConsumer;
        abstract unsetDefaultColor(): void;
    }
    type BufferVertexConsumer_ = BufferVertexConsumer;
    class RegistrarManager {
        static get(modId: string): Internal.RegistrarManager;
        /**
         * @deprecated
        */
        static getId<T>(object: T, fallback: Internal.Registry_<T>): ResourceLocation;
        get<T>(key: Internal.ResourceKey_<Internal.Registry<T>>): Internal.Registrar<T>;
        /**
         * @deprecated
        */
        get<T>(registry: Internal.Registry_<T>): Internal.Registrar<T>;
        getModId(): string;
        forRegistry<T>(key: Internal.ResourceKey_<Internal.Registry<T>>, callback: Internal.Consumer_<Internal.Registrar<T>>): void;
        static getId<T>(object: T, fallback: Internal.ResourceKey_<Internal.Registry<T>>): ResourceLocation;
        builder<T>(registryId: ResourceLocation_, ...typeGetter: T[]): Internal.RegistrarBuilder<T>;
        get modId(): string
    }
    type RegistrarManager_ = RegistrarManager;
    class DragSourceEvent extends Internal.EventObject {
        constructor(arg0: Internal.DragSourceContext_, arg1: number, arg2: number)
        constructor(arg0: Internal.DragSourceContext_)
        getX(): number;
        getY(): number;
        getDragSourceContext(): Internal.DragSourceContext;
        getLocation(): Internal.Point;
        get x(): number
        get y(): number
        get dragSourceContext(): Internal.DragSourceContext
        get location(): Internal.Point
    }
    type DragSourceEvent_ = DragSourceEvent;
    interface ProfilerMeasured {
        abstract profiledMetrics(): Internal.List<Internal.MetricSampler>;
        (): Internal.List_<Internal.MetricSampler>;
    }
    type ProfilerMeasured_ = ProfilerMeasured;
    class StructureTemplate$StructureEntityInfo {
        constructor($$0: Vec3d_, $$1: BlockPos_, $$2: Internal.CompoundTag_)
        readonly nbt: Internal.CompoundTag;
        readonly pos: Vec3d;
        readonly blockPos: BlockPos;
    }
    type StructureTemplate$StructureEntityInfo_ = StructureTemplate$StructureEntityInfo;
    class NoiseProvider extends Internal.NoiseBasedStateProvider implements Internal.NoiseProviderAccessor {
        constructor($$0: number, $$1: Internal.NormalNoise$NoiseParameters_, $$2: number, $$3: Internal.List_<Internal.BlockState>)
        getStates(): Internal.List<any>;
        get states(): Internal.List<any>
        static readonly CODEC: Internal.Codec<Internal.NoiseProvider>;
    }
    type NoiseProvider_ = NoiseProvider;
    abstract class PlayerList {
        constructor($$0: Internal.MinecraftServer_, $$1: Internal.LayeredRegistryAccess_<Internal.RegistryLayer>, $$2: Internal.PlayerDataStorage_, $$3: number)
        placeNewPlayer($$0: Internal.Connection_, $$1: Internal.ServerPlayer_): void;
        sendAllPlayerInfo($$0: Internal.ServerPlayer_): void;
        setSimulationDistance($$0: number): void;
        getSingleplayerData(): Internal.CompoundTag;
        broadcastSystemToTeam($$0: Internal.Player_, $$1: net.minecraft.network.chat.Component_): void;
        broadcastSystemToAllExceptTeam($$0: Internal.Player_, $$1: net.minecraft.network.chat.Component_): void;
        broadcast($$0: Internal.Player_, $$1: number, $$2: number, $$3: number, $$4: number, $$5: Internal.ResourceKey_<Internal.Level>, $$6: Internal.Packet_<any>): void;
        reloadResources(): void;
        sendPlayerPermissionLevel($$0: Internal.ServerPlayer_): void;
        saveAll(): void;
        remove($$0: Internal.ServerPlayer_): void;
        isOp($$0: Internal.GameProfile_): boolean;
        getPlayerCount(): number;
        getIpBans(): Internal.IpBanList;
        addWorldborderListener($$0: Internal.ServerLevel_): void;
        reloadWhiteList(): void;
        getOpNames(): string[];
        setViewDistance($$0: number): void;
        getPlayer($$0: Internal.UUID_): Internal.ServerPlayer;
        tick(): void;
        broadcastSystemMessage($$0: net.minecraft.network.chat.Component_, $$1: boolean): void;
        broadcastChatMessage($$0: Internal.PlayerChatMessage_, $$1: Internal.CommandSourceStack_, $$2: Internal.ChatType$Bound_): void;
        getSimulationDistance(): number;
        isWhiteListed($$0: Internal.GameProfile_): boolean;
        getMaxPlayers(): number;
        setAllowCheatsForAllPlayers($$0: boolean): void;
        isAllowCheatsForAllPlayers(): boolean;
        getServer(): Internal.MinecraftServer;
        broadcastChatMessage($$0: Internal.PlayerChatMessage_, $$1: Internal.ServerPlayer_, $$2: Internal.ChatType$Bound_): void;
        canPlayerLogin($$0: Internal.SocketAddress_, $$1: Internal.GameProfile_): net.minecraft.network.chat.Component;
        getWhiteList(): Internal.UserWhiteList;
        broadcastAll($$0: Internal.Packet_<any>, $$1: Internal.ResourceKey_<Internal.Level>): void;
        respawn($$0: Internal.ServerPlayer_, $$1: boolean): Internal.ServerPlayer;
        broadcastAll($$0: Internal.Packet_<any>): void;
        getPlayers(): Internal.List<Internal.ServerPlayer>;
        getPlayerAdvancements($$0: Internal.ServerPlayer_): Internal.PlayerAdvancements;
        op($$0: Internal.GameProfile_): void;
        getPlayerNamesArray(): string[];
        getPlayerByName($$0: string): Internal.ServerPlayer;
        load($$0: Internal.ServerPlayer_): Internal.CompoundTag;
        getPlayerStats($$0: Internal.Player_): Internal.ServerStatsCounter;
        deop($$0: Internal.GameProfile_): void;
        removeAll(): void;
        getWhiteListNames(): string[];
        sendLevelInfo($$0: Internal.ServerPlayer_, $$1: Internal.ServerLevel_): void;
        canBypassPlayerLimit($$0: Internal.GameProfile_): boolean;
        setUsingWhiteList($$0: boolean): void;
        getViewDistance(): number;
        getPlayerForLogin($$0: Internal.GameProfile_): Internal.ServerPlayer;
        isUsingWhitelist(): boolean;
        broadcastSystemMessage($$0: net.minecraft.network.chat.Component_, $$1: Internal.Function_<Internal.ServerPlayer, net.minecraft.network.chat.Component>, $$2: boolean): void;
        getBans(): Internal.UserBanList;
        getPlayersWithAddress($$0: string): Internal.List<Internal.ServerPlayer>;
        getOps(): Internal.ServerOpList;
        set simulationDistance($$0: number)
        get singleplayerData(): Internal.CompoundTag
        get playerCount(): number
        get ipBans(): Internal.IpBanList
        get opNames(): string[]
        set viewDistance($$0: number)
        get simulationDistance(): number
        get maxPlayers(): number
        set allowCheatsForAllPlayers($$0: boolean)
        get allowCheatsForAllPlayers(): boolean
        get server(): Internal.MinecraftServer
        get whiteList(): Internal.UserWhiteList
        get players(): Internal.List<Internal.ServerPlayer>
        get playerNamesArray(): string[]
        get whiteListNames(): string[]
        set usingWhiteList($$0: boolean)
        get viewDistance(): number
        get usingWhitelist(): boolean
        get bans(): Internal.UserBanList
        get ops(): Internal.ServerOpList
        static readonly USERBANLIST_FILE: Internal.File;
        static readonly CHAT_FILTERED_FULL: Internal.MutableComponent;
        static readonly OPLIST_FILE: Internal.File;
        static readonly IPBANLIST_FILE: Internal.File;
        static readonly WHITELIST_FILE: Internal.File;
    }
    type PlayerList_ = PlayerList;
    class TropicalFish$Pattern extends Internal.Enum<Internal.TropicalFish$Pattern> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static valueOf($$0: string): Internal.TropicalFish$Pattern;
        getSerializedName(): string;
        base(): Internal.TropicalFish$Base;
        getPackedId(): number;
        static byId($$0: number): Internal.TropicalFish$Pattern;
        displayName(): net.minecraft.network.chat.Component;
        static values(): Internal.TropicalFish$Pattern[];
        get serializedName(): string
        get packedId(): number
        static readonly BETTY: Internal.TropicalFish$Pattern;
        static readonly CLAYFISH: Internal.TropicalFish$Pattern;
        static readonly SUNSTREAK: Internal.TropicalFish$Pattern;
        static readonly DASHER: Internal.TropicalFish$Pattern;
        static readonly STRIPEY: Internal.TropicalFish$Pattern;
        static readonly KOB: Internal.TropicalFish$Pattern;
        static readonly SPOTTY: Internal.TropicalFish$Pattern;
        static readonly BLOCKFISH: Internal.TropicalFish$Pattern;
        static readonly GLITTER: Internal.TropicalFish$Pattern;
        static readonly CODEC: Internal.Codec<Internal.TropicalFish$Pattern>;
        static readonly SNOOPER: Internal.TropicalFish$Pattern;
        static readonly BRINELY: Internal.TropicalFish$Pattern;
        static readonly FLOPPER: Internal.TropicalFish$Pattern;
    }
    type TropicalFish$Pattern_ = "sunstreak" | "dasher" | "glitter" | "snooper" | "stripey" | "blockfish" | "flopper" | "kob" | TropicalFish$Pattern | "betty" | "clayfish" | "brinely" | "spotty";
    class FireworkRocketEntity extends Internal.Projectile implements Internal.FireworkRocketEntityKJS, Internal.ItemSupplier {
        constructor($$0: Internal.Level_, $$1: number, $$2: number, $$3: number, $$4: Internal.ItemStack_)
        constructor($$0: Internal.Level_, $$1: Internal.ItemStack_, $$2: number, $$3: number, $$4: number, $$5: boolean)
        constructor($$0: Internal.EntityType_<Internal.FireworkRocketEntity>, $$1: Internal.Level_)
        constructor($$0: Internal.Level_, $$1: Internal.ItemStack_, $$2: Internal.Entity_, $$3: number, $$4: number, $$5: number, $$6: boolean)
        constructor($$0: Internal.Level_, $$1: Internal.ItemStack_, $$2: Internal.LivingEntity_)
        constructor($$0: Internal.Level_, $$1: Internal.Entity_, $$2: number, $$3: number, $$4: number, $$5: Internal.ItemStack_)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        method_5652($$0: Internal.CompoundTag_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        isShotAtAngle(): boolean;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        method_5749($$0: Internal.CompoundTag_): void;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        setLifetimeKJS(arg0: number): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        get shotAtAngle(): boolean
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        set lifetimeKJS(arg0: number)
        get frame(): boolean
        get profile(): Internal.GameProfile
    }
    type FireworkRocketEntity_ = FireworkRocketEntity;
    interface IAgriPlantModifier {
        onRightClickPre(crop: Internal.AgriCrop_, stack: Internal.ItemStack_, entity: Internal.Entity_): Internal.Optional<Internal.InteractionResult>;
        onHarvest(crop: Internal.AgriCrop_, entity: Internal.LivingEntity_): void;
        onFertilized(crop: Internal.AgriCrop_, fertilizer: Internal.ItemStack_, random: Internal.RandomSource_): void;
        onPlanted(crop: Internal.AgriCrop_, entity: Internal.LivingEntity_): void;
        getRedstonePower(crop: Internal.AgriCrop_): number;
        onRemoved(crop: Internal.AgriCrop_): void;
        onGrowth(crop: Internal.AgriCrop_): void;
        onBroken(crop: Internal.AgriCrop_, entity: Internal.LivingEntity_): void;
        onRandomTick(crop: Internal.AgriCrop_, random: Internal.RandomSource_): void;
        onEntityCollision(crop: Internal.AgriCrop_, entity: Internal.Entity_): void;
        getBrightness(crop: Internal.AgriCrop_): number;
        onClipped(crop: Internal.AgriCrop_, clipper: Internal.ItemStack_, entity: Internal.LivingEntity_): void;
        onSpawned(crop: Internal.AgriCrop_): void;
        onRightClickPost(crop: Internal.AgriCrop_, stack: Internal.ItemStack_, entity: Internal.Entity_): Internal.Optional<Internal.InteractionResult>;
    }
    type IAgriPlantModifier_ = IAgriPlantModifier;
    class SmithingTrimRecipe implements Internal.SmithingTrimRecipeAccessor, Internal.AccessorSmithingTrimRecipe, Internal.SmithingRecipe, com.illusivesoulworks.polymorph.mixin.core.AccessorSmithingTrimRecipe {
        constructor($$0: ResourceLocation_, $$1: Internal.Ingredient_, $$2: Internal.Ingredient_, $$3: Internal.Ingredient_)
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        isBaseIngredient($$0: Internal.ItemStack_): boolean;
        getTemplate(): Internal.Ingredient;
        getBase(): Internal.Ingredient;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble($$0: net.minecraft.world.Container_, $$1: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches($$0: net.minecraft.world.Container_, $$1: Internal.Level_): boolean;
        getAddition(): Internal.Ingredient;
        getMod(): string;
        getRemainingItems($$0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem($$0: Internal.RegistryAccess_): Internal.ItemStack;
        canCraftInDimensions($$0: number, $$1: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        isTemplateIngredient($$0: Internal.ItemStack_): boolean;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        isAdditionIngredient($$0: Internal.ItemStack_): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get template(): Internal.Ingredient
        get base(): Internal.Ingredient
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get addition(): Internal.Ingredient
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        readonly addition: Internal.Ingredient;
        readonly template: Internal.Ingredient;
        readonly base: Internal.Ingredient;
    }
    type SmithingTrimRecipe_ = SmithingTrimRecipe;
    class MoltenTinFluid$Source extends Internal.MoltenTinFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenTinFluid$Source_ = MoltenTinFluid$Source;
    class ServerboundPlayerCommandPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.Entity_, $$1: Internal.ServerboundPlayerCommandPacket$Action_)
        constructor($$0: Internal.Entity_, $$1: Internal.ServerboundPlayerCommandPacket$Action_, $$2: number)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        getData(): number;
        getAction(): Internal.ServerboundPlayerCommandPacket$Action;
        isSkippable(): boolean;
        getId(): number;
        get data(): number
        get action(): Internal.ServerboundPlayerCommandPacket$Action
        get skippable(): boolean
        get id(): number
    }
    type ServerboundPlayerCommandPacket_ = ServerboundPlayerCommandPacket;
    class MinecartController implements Internal.INBTSerializable<Internal.CompoundTag> {
        constructor(minecart: Internal.AbstractMinecart_)
        decouple(): void;
        getCoupledCart(asMain: boolean): Internal.UUID;
        deserializeNBT(arg0: Internal.Tag_): void;
        static empty(): Internal.MinecartController;
        setStalledExternally(stall: boolean): void;
        cart(): Internal.AbstractMinecart;
        isCoupledThroughContraption(): boolean;
        tick(): void;
        isLeadingCoupling(): boolean;
        deserializeNBT(nbt: Internal.CompoundTag_): void;
        isStalled(): boolean;
        isPresent(): boolean;
        removeConnection(main: boolean): void;
        hasContraptionCoupling(current: boolean): boolean;
        coupleWith(isLeading: boolean, coupled: Internal.UUID_, length: number, contraption: boolean): void;
        isConnectedToCoupling(): boolean;
        serializeNBT(): Internal.Tag;
        isFullyCoupled(): boolean;
        getCouplingLength(leading: boolean): number;
        prepareForCoupling(isLeading: boolean): void;
        sendData(): void;
        set stalledExternally(stall: boolean)
        get coupledThroughContraption(): boolean
        get leadingCoupling(): boolean
        get stalled(): boolean
        get present(): boolean
        get connectedToCoupling(): boolean
        get fullyCoupled(): boolean
        static EMPTY: Internal.MinecartController;
    }
    type MinecartController_ = MinecartController;
    class TableClothBlockEntity extends Internal.SmartBlockEntity implements Internal.TransformableBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getItemsForRender(): Internal.List<Internal.ItemStack>;
        notifyShopUpdate(): void;
        targetsPriceTag(player: Internal.Player_, ray: Internal.BlockHitResult_): boolean;
        invalidateItemsForRender(): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getPaymentAmount(): number;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        getPaymentItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        use(player: Internal.Player_, ray: Internal.BlockHitResult_): Internal.InteractionResult;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        transform(blockEntity: Internal.BlockEntity_, transform: Internal.StructureTransform_): void;
        isShop(): boolean;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getStockLevelForTrade(otherPurchases: Internal.ShoppingListItem$ShoppingList_): number;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        useShop(player: Internal.Player_): Internal.InteractionResult;
        get itemsForRender(): Internal.List<Internal.ItemStack>
        get paymentAmount(): number
        get paymentItem(): Internal.ItemStack
        get infiniteBoundingBox(): Internal.AABB
        get shop(): boolean
        owner: Internal.UUID;
        facing: Internal.Direction;
        manuallyAddedItems: Internal.List<Internal.ItemStack>;
        computerBehaviour: Internal.AbstractComputerBehaviour;
        priceTag: Internal.FilteringBehaviour;
        sideOccluded: boolean;
        requestData: Internal.AutoRequestData;
    }
    type TableClothBlockEntity_ = TableClothBlockEntity;
    abstract class AbstractInterruptibleChannel implements Internal.InterruptibleChannel, Internal.Channel {
        isOpen(): boolean;
        close(): void;
        get open(): boolean
    }
    type AbstractInterruptibleChannel_ = AbstractInterruptibleChannel;
    class StatsNBT {
        hasStat(stat: Internal.IToolStat_<any>): boolean;
        serializeToNBT(): Internal.CompoundTag;
        getInt(stat: Internal.IToolStat_<number>): number;
        static fromNetwork(buffer: Internal.FriendlyByteBuf_): Internal.StatsNBT;
        static builder(): Internal.StatsNBT$Builder;
        getContainedStats(): Internal.Set<Internal.IToolStat<any>>;
        get<T>(stat: Internal.IToolStat_<T>): T;
        static readFromNBT(inbt: Internal.Tag_): Internal.StatsNBT;
        toNetwork(buffer: Internal.FriendlyByteBuf_): void;
        get containedStats(): Internal.Set<Internal.IToolStat<any>>
        static SERIALIZER: Internal.StatsNBT$Serializer;
        static readonly EMPTY: Internal.StatsNBT;
    }
    type StatsNBT_ = StatsNBT;
    class RadialChassisBlock extends Internal.AbstractChassisBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.ChassisBlockEntity>): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.ChassisBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.ChassisBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.ChassisBlockEntity;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly STICKY_WEST: Internal.BooleanProperty;
        static readonly STICKY_NORTH: Internal.BooleanProperty;
        static readonly STICKY_EAST: Internal.BooleanProperty;
        static readonly STICKY_SOUTH: Internal.BooleanProperty;
    }
    type RadialChassisBlock_ = RadialChassisBlock;
    class PowahBookItem extends owmii.powah.lib.item.ItemBase {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        oneTimeInfo(player: Internal.Player_, stack: Internal.ItemStack_, component: net.minecraft.network.chat.Component_): void;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getItemModelType(): Internal.ItemModelType;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get itemModelType(): Internal.ItemModelType
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type PowahBookItem_ = PowahBookItem;
    interface WorldCreationContext$DimensionsUpdater extends Internal.BiFunction<Internal.RegistryAccess$Frozen, Internal.WorldDimensions, Internal.WorldDimensions> {
        andThen<V>(arg0: Internal.Function_<Internal.WorldDimensions, V>): Internal.BiFunction<Internal.RegistryAccess$Frozen, Internal.WorldDimensions, V>;
        abstract apply(arg0: Internal.RegistryAccess$Frozen_, arg1: Internal.WorldDimensions_): Internal.WorldDimensions;
        (arg0: Internal.RegistryAccess$Frozen, arg1: Internal.WorldDimensions): Internal.WorldDimensions_;
    }
    type WorldCreationContext$DimensionsUpdater_ = WorldCreationContext$DimensionsUpdater;
    interface ItemKJS extends Internal.IngredientSupplierKJS {
        setFireResistant(b: boolean): void;
        setRarity(r: Internal.Rarity_): void;
        setNameKey(key: string): void;
        setDigSpeed(speed: number): void;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setAttackSpeed(attackSpeed: number): void;
        setAttackDamage(attackDamage: number): void;
        getIdLocation(): ResourceLocation;
        getMod(): string;
        kjs$asIngredient(): Internal.Ingredient;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        getTypeData(): Internal.CompoundTag;
        getId(): string;
        getTypeItemStackKey(): Internal.ItemStackKey;
        self(): Internal.Item;
        setMaxStackSize(i: number): void;
        setBurnTime(i: number): void;
        setFoodProperties(properties: Internal.FoodProperties_): void;
        setCraftingRemainder(i: Internal.Item_): void;
        setMaxDamage(i: number): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        getItemBuilder(): Internal.ItemBuilder;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set fireResistant(b: boolean)
        set rarity(r: Internal.Rarity_)
        set nameKey(key: string)
        set digSpeed(speed: number)
        set itemBuilder(b: Internal.ItemBuilder_)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get typeData(): Internal.CompoundTag
        get id(): string
        get typeItemStackKey(): Internal.ItemStackKey
        set maxStackSize(i: number)
        set burnTime(i: number)
        set foodProperties(properties: Internal.FoodProperties_)
        set craftingRemainder(i: Internal.Item_)
        set maxDamage(i: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        get itemBuilder(): Internal.ItemBuilder
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemKJS_ = ItemKJS;
    class SpringFeature extends Internal.Feature<Internal.SpringConfiguration> {
        constructor($$0: Internal.Codec_<Internal.SpringConfiguration>)
    }
    type SpringFeature_ = SpringFeature;
    class AbstractMinecart$Type extends Internal.Enum<Internal.AbstractMinecart$Type> {
        static valueOf($$0: string): Internal.AbstractMinecart$Type;
        static values(): Internal.AbstractMinecart$Type[];
        static readonly SPAWNER: Internal.AbstractMinecart$Type;
        static readonly RIDEABLE: Internal.AbstractMinecart$Type;
        static readonly CHEST: Internal.AbstractMinecart$Type;
        static readonly HOPPER: Internal.AbstractMinecart$Type;
        static readonly TNT: Internal.AbstractMinecart$Type;
        static readonly COMMAND_BLOCK: Internal.AbstractMinecart$Type;
        static readonly FURNACE: Internal.AbstractMinecart$Type;
    }
    type AbstractMinecart$Type_ = AbstractMinecart$Type | "spawner" | "hopper" | "command_block" | "railway_jukebox" | "furnace" | "railway_workbench" | "rideable" | "chest" | "tnt";
    class CraftingSubmitErrorCode extends Internal.Enum<Internal.CraftingSubmitErrorCode> {
        static values(): Internal.CraftingSubmitErrorCode[];
        static valueOf(name: string): Internal.CraftingSubmitErrorCode;
        static readonly INCOMPLETE_PLAN: Internal.CraftingSubmitErrorCode;
        static readonly CPU_TOO_SMALL: Internal.CraftingSubmitErrorCode;
        static readonly MISSING_INGREDIENT: Internal.CraftingSubmitErrorCode;
        static readonly NO_CPU_FOUND: Internal.CraftingSubmitErrorCode;
        static readonly NO_SUITABLE_CPU_FOUND: Internal.CraftingSubmitErrorCode;
        static readonly CPU_BUSY: Internal.CraftingSubmitErrorCode;
        static readonly CPU_OFFLINE: Internal.CraftingSubmitErrorCode;
    }
    type CraftingSubmitErrorCode_ = "no_suitable_cpu_found" | "cpu_too_small" | "cpu_offline" | "missing_ingredient" | CraftingSubmitErrorCode | "no_cpu_found" | "cpu_busy" | "incomplete_plan";
    class SmokeStackBlockEntity extends Internal.SmartBlockEntity implements Internal.IHaveGoggleInformation {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setSoul(isSoul: boolean): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        isSoul(): boolean;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        getColor(): Internal.DyeColor;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        addToGoggleTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
        setColor(color: Internal.DyeColor_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        set soul(isSoul: boolean)
        get soul(): boolean
        get color(): Internal.DyeColor
        get infiniteBoundingBox(): Internal.AABB
        set color(color: Internal.DyeColor_)
    }
    type SmokeStackBlockEntity_ = SmokeStackBlockEntity;
    class BooleanComponent implements Internal.RecipeComponent<boolean> {
        constructor()
        write(arg0: Internal.RecipeJS_, arg1: any): Internal.JsonElement;
        /**
         * Returns a new RecipeComponent that maps the keys in a JsonObject according to the provided map, both before the json gets passed to the component and after the component returns a written json object.
         * The mappings should be provided in the format `{recipe: "component"}` where recipe is the key as in the recipe, and component is the key as how the RecipeComponent expects it.
         * Any keys not included in the provided map will be ignored, and any keys in the provided map that are not in either the input object or output object will be ignored.
         * Note that if the input or output is not a JsonObject (ie its an ItemStack, or it is a JsonPrimitive) then that will pass through this without being modified.
         * If you wish to handle those situations use the actual map function
        */
        simpleMap(mappings: any): Internal.SimpleMappingRecipeComponent<boolean>;
        read(recipe: Internal.RecipeJS_, from: any): boolean;
        asArrayOrSelf(): Internal.ArrayRecipeComponent<boolean>;
        /**
         * Returns a new RecipeComponent that applies the mappingFrom function after the component writes to json, before that json is saved
        */
        mapOut(mappingFrom: Internal.UnaryOperator_<Internal.JsonElement>): Internal.MappingRecipeComponent<boolean>;
        and<O>(other: Internal.RecipeComponent_<O>): Internal.AndRecipeComponent<boolean, O>;
        role(): Internal.ComponentRole;
        componentClass(): typeof any;
        asArray(): Internal.ArrayRecipeComponent<boolean>;
        readFromJson(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<boolean>, json: Internal.JsonObject_): void;
        asMap<K>(key: Internal.RecipeComponent_<K>): Internal.RecipeComponent<Internal.TinyMap<K, boolean>>;
        constructorDescription(ctx: Internal.DescriptionContext_): Internal.TypeDescJS;
        replaceInput(recipe: Internal.RecipeJS_, original: boolean, match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        componentType(): string;
        write(recipe: Internal.RecipeJS_, value: boolean): Internal.JsonElement;
        static builder(): Internal.RecipeComponentBuilder;
        hasPriority(recipe: Internal.RecipeJS_, from: any): boolean;
        asPatternKey(): Internal.RecipeComponent<Internal.TinyMap<string, boolean>>;
        checkEmpty(key: Internal.RecipeKey_<boolean>, value: boolean): string;
        key(name: string): Internal.RecipeKey<boolean>;
        orSelf(): Internal.RecipeComponent<boolean>;
        static builder(...key: Internal.RecipeKey_<any>[]): Internal.RecipeComponentBuilder;
        replaceOutput(recipe: Internal.RecipeJS_, original: boolean, match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        checkValueHasChanged(oldValue: boolean, newValue: boolean): boolean;
        or<O>(other: Internal.RecipeComponent_<O>): Internal.OrRecipeComponent<boolean, O>;
        isInput(recipe: Internal.RecipeJS_, value: boolean, match: Internal.ReplacementMatch_): boolean;
        writeToJson(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<boolean>, json: Internal.JsonObject_): void;
        readFromMap(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<boolean>, map: Internal.Map_<any, any>): void;
        /**
         * Returns a new RecipeComponent that applies the mappingTo function to the input before it is passed to this component to be read, and the mappingFrom function after the component writes to json, before that json is saved
        */
        map(mappingTo: Internal.UnaryOperator_<any>, mappingFrom: Internal.UnaryOperator_<Internal.JsonElement>): Internal.MappingRecipeComponent<boolean>;
        /**
         * Returns a new RecipeComponent that applies the mappingTo function to the input before it is passed to this component to be read
        */
        mapIn(mappingTo: Internal.UnaryOperator_<any>): Internal.MappingRecipeComponent<boolean>;
        isOutput(recipe: Internal.RecipeJS_, value: boolean, match: Internal.ReplacementMatch_): boolean;
        static readonly BOOLEAN: Internal.BooleanComponent;
    }
    type BooleanComponent_ = BooleanComponent;
    class CampfireBlock extends Internal.BaseEntityBlock implements Internal.SimpleWaterloggedBlock {
        constructor($$0: boolean, $$1: number, $$2: Internal.BlockBehaviour$Properties_)
        static isLitCampfire($$0: Internal.BlockState_): boolean;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        handler$cml000$farmersdelight$isFDSmokeSource(state: Internal.BlockState_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        static isSmokeyPos($$0: Internal.Level_, $$1: BlockPos_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        static canLight($$0: Internal.BlockState_): boolean;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        static dowse($$0: Internal.Entity_, $$1: Internal.LevelAccessor_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static makeParticles($$0: Internal.Level_, $$1: BlockPos_, $$2: boolean, $$3: boolean): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly SIGNAL_FIRE: Internal.BooleanProperty;
        static readonly LIT: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type CampfireBlock_ = CampfireBlock;
    class BlankSailBlockItem extends Internal.BlockItem {
        constructor(block: Internal.Block_, properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BlankSailBlockItem_ = BlankSailBlockItem;
    class QuartzAxeItem extends Internal.AxeItem {
        constructor(props: Internal.Item$Properties_, type: any_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        static setStrippedBlocks(strippedBlocks: Internal.Map_<Internal.Block, Internal.Block>): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        static getStrippedBlocks(): Internal.Map<Internal.Block, Internal.Block>;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set strippedBlocks(strippedBlocks: Internal.Map_<Internal.Block, Internal.Block>)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        get strippedBlocks(): Internal.Map<Internal.Block, Internal.Block>
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type QuartzAxeItem_ = QuartzAxeItem;
    class ArrayBackedEvent <T> extends net.fabricmc.fabric.api.event.Event<T> {
    }
    type ArrayBackedEvent_<T> = ArrayBackedEvent<T>;
    class Resource implements Internal.FabricResource {
        constructor($$0: Internal.PackResources_, $$1: Internal.IoSupplier_<Internal.InputStream>, $$2: Internal.IoSupplier_<Internal.ResourceMetadata>)
        constructor($$0: Internal.PackResources_, $$1: Internal.IoSupplier_<Internal.InputStream>)
        open(): Internal.InputStream;
        getFabricPackSource(): Internal.PackSource;
        openAsReader(): Internal.BufferedReader;
        metadata(): Internal.ResourceMetadata;
        isBuiltin(): boolean;
        sourcePackId(): string;
        source(): Internal.PackResources;
        get fabricPackSource(): Internal.PackSource
        get builtin(): boolean
    }
    type Resource_ = Resource;
    class ServerboundUseItemPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.InteractionHand_, $$1: number)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        getSequence(): number;
        getHand(): Internal.InteractionHand;
        isSkippable(): boolean;
        get sequence(): number
        get hand(): Internal.InteractionHand
        get skippable(): boolean
    }
    type ServerboundUseItemPacket_ = ServerboundUseItemPacket;
    class ServerboundChangeDifficultyPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.Difficulty_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getDifficulty(): Internal.Difficulty;
        handle($$0: Internal.ServerGamePacketListener_): void;
        isSkippable(): boolean;
        get difficulty(): Internal.Difficulty
        get skippable(): boolean
    }
    type ServerboundChangeDifficultyPacket_ = ServerboundChangeDifficultyPacket;
    class QuartzSpadeItem extends Internal.ShovelItem {
        constructor(props: Internal.Item$Properties_, type: any_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static getPathStates(): Internal.Map<Internal.Block, Internal.BlockState>;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get pathStates(): Internal.Map<Internal.Block, Internal.BlockState>
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type QuartzSpadeItem_ = QuartzSpadeItem;
    abstract class RootPlacer {
        constructor($$0: Internal.IntProvider_, $$1: Internal.BlockStateProvider_, $$2: Internal.Optional_<any>)
        getTrunkOrigin($$0: BlockPos_, $$1: Internal.RandomSource_): BlockPos;
        abstract placeRoots(arg0: Internal.LevelSimulatedReader_, arg1: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        static readonly CODEC: Internal.Codec<Internal.RootPlacer>;
    }
    type RootPlacer_ = RootPlacer;
    interface CustomArmPoseItem {
        abstract getArmPose(arg0: Internal.ItemStack_, arg1: Internal.AbstractClientPlayer_, arg2: Internal.InteractionHand_): Internal.HumanoidModel$ArmPose;
        (arg0: Internal.ItemStack, arg1: Internal.AbstractClientPlayer, arg2: Internal.InteractionHand): Internal.HumanoidModel$ArmPose_;
    }
    type CustomArmPoseItem_ = CustomArmPoseItem;
    class ScheduleRuntime implements Internal.AccessorScheduleRuntime {
        constructor(train: Internal.Train_)
        write(): Internal.CompoundTag;
        tick(level: Internal.Level_): void;
        transitInterrupted(): void;
        getSchedule(): com.simibubi.create.content.trains.schedule.Schedule;
        startCurrentInstruction(level: Internal.Level_): Internal.DiscoveredPath;
        tickConditions(level: Internal.Level_): void;
        setSchedule(schedule: com.simibubi.create.content.trains.schedule.Schedule_, auto: boolean): void;
        destinationReached(): void;
        setCooldown(arg0: number): void;
        getWaitingStatus(level: Internal.Level_): Internal.MutableComponent;
        read(tag: Internal.CompoundTag_): void;
        startCooldown(): void;
        returnSchedule(): Internal.ItemStack;
        setSchedulePresentClientside(present: boolean): void;
        discardSchedule(): void;
        getTrain(): Internal.Train;
        submitPredictions(): Internal.Collection<Internal.GlobalTrainDisplayData$TrainDeparturePrediction>;
        get schedule(): com.simibubi.create.content.trains.schedule.Schedule
        set cooldown(arg0: number)
        set schedulePresentClientside(present: boolean)
        get train(): Internal.Train
        completed: boolean;
        conditionProgress: Internal.List<number>;
        currentTitle: string;
        schedule: com.simibubi.create.content.trains.schedule.Schedule;
        ticksInTransit: number;
        currentEntry: number;
        conditionContext: Internal.List<Internal.CompoundTag>;
        paused: boolean;
        train: Internal.Train;
        predictionTicks: Internal.List<number>;
        displayLinkUpdateRequested: boolean;
        isAutoSchedule: boolean;
        state: Internal.ScheduleRuntime$State;
    }
    type ScheduleRuntime_ = ScheduleRuntime;
    class ConfigInventory extends Internal.GenericStackInv {
        keySet(): Internal.Set<Internal.AEKey>;
        static storage(size: number, changeListener: Internal.Runnable_): Internal.ConfigInventory;
        addFilter(what: Internal.AEKey_): this;
        static configStacks(filter: Internal.AEKeyFilter_, size: number, changeListener: Internal.Runnable_, allowOverstacking: boolean): Internal.ConfigInventory;
        static checkPreconditions(what: Internal.AEKey_, amount: number, mode: Internal.Actionable_, source: Internal.IActionSource_): void;
        isPreferredStorageFor(what: Internal.AEKey_, source: Internal.IActionSource_): boolean;
        getAvailableStacks(): Internal.KeyCounter;
        static configTypes(filter: Internal.AEKeyFilter_, size: number, changeListener: Internal.Runnable_): Internal.ConfigInventory;
        addFilter(item: Internal.ItemLike_): this;
        addFilter(fluid: Internal.Fluid_): this;
        static configTypes(size: number, changeListener: Internal.Runnable_): Internal.ConfigInventory;
        static storage(filter: Internal.AEKeyFilter_, size: number, changeListener: Internal.Runnable_): Internal.ConfigInventory;
        get availableStacks(): Internal.KeyCounter
        static readonly EMPTY_TYPES: Internal.ConfigInventory;
    }
    type ConfigInventory_ = ConfigInventory;
    class Explosion$BlockInteraction extends Internal.Enum<Internal.Explosion$BlockInteraction> {
        static valueOf($$0: string): Internal.Explosion$BlockInteraction;
        static values(): Internal.Explosion$BlockInteraction[];
        static readonly KEEP: Internal.Explosion$BlockInteraction;
        static readonly DESTROY: Internal.Explosion$BlockInteraction;
        static readonly DESTROY_WITH_DECAY: Internal.Explosion$BlockInteraction;
    }
    type Explosion$BlockInteraction_ = "keep" | "destroy_with_decay" | Explosion$BlockInteraction | "destroy";
    abstract class HandheldItemBuilder extends Internal.ItemBuilder {
        constructor(i: ResourceLocation_, d: number, s: number)
        /**
         * Sets the attack speed of the tool.
        */
        speed(f: number): this;
        /**
         * Sets the base attack damage of the tool. Different tools have different baselines.
         * 
         * For example, a sword has a baseline of 3, while an axe has a baseline of 6.
         * 
         * The actual damage is the sum of the baseline and the attackDamageBonus from tier.
        */
        attackDamageBaseline(f: number): this;
        /**
         * Sets the base attack speed of the tool. Different tools have different baselines.
         * 
         * For example, a sword has a baseline of -2.4, while an axe has a baseline of -3.1.
         * 
         * The actual speed is the sum of the baseline and the speed from tier + 4 (bare hand).
        */
        speedBaseline(f: number): this;
        /**
         * Modifies the tool tier.
        */
        modifyTier(callback: Internal.Consumer_<Internal.MutableToolTier>): this;
        /**
         * Sets the attack damage bonus of the tool.
        */
        attackDamageBonus(f: number): this;
        tier(t: Internal.Tier_): this;
    }
    type HandheldItemBuilder_ = HandheldItemBuilder;
    class TinkersChestBlock extends slimeknights.tconstruct.tables.block.ChestBlock implements Internal.BlockPickInteractionAware {
        constructor(builder: Internal.BlockBehaviour$Properties_, be: any_<Internal.BlockEntity>, dropsItems: boolean)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getPickedStack(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, player: Internal.Player_, result: Internal.HitResult_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type TinkersChestBlock_ = TinkersChestBlock;
    abstract class UnmodifiableListIterator <E> extends Internal.UnmodifiableIterator<E> implements Internal.ListIterator<E> {
        abstract nextIndex(): number;
        abstract hasPrevious(): boolean;
        forEachRemaining(arg0: Internal.Consumer_<E>): void;
        abstract next(): E;
        abstract previous(): E;
        /**
         * @deprecated
        */
        add(arg0: E): void;
        /**
         * @deprecated
        */
        set(arg0: E): void;
        abstract previousIndex(): number;
    }
    type UnmodifiableListIterator_<E> = UnmodifiableListIterator<E>;
    interface EntityTypeExtension <T extends Internal.Entity> {
        abstract flywheel$getVisualizer(): Internal.EntityVisualizer<T>;
        abstract flywheel$setVisualizer(arg0: Internal.EntityVisualizer_<T>): void;
    }
    type EntityTypeExtension_<T extends Internal.Entity> = EntityTypeExtension<T>;
    class BrushableBlockEntity extends Internal.BlockEntity {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        setLootTable($$0: ResourceLocation_, $$1: number): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getUpdatePacket(): Internal.Packet<any>;
        onLoad(): void;
        getHitDirection(): Internal.Direction;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        brush($$0: number, $$1: Internal.Player_, $$2: Internal.Direction_): boolean;
        invalidateCaps(): void;
        checkReset(): void;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        unpackLootTable($$0: Internal.Player_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get updatePacket(): Internal.Packet<any>
        get hitDirection(): Internal.Direction
        get item(): Internal.ItemStack
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket
    }
    type BrushableBlockEntity_ = BrushableBlockEntity;
    class ModifierRecipe extends Internal.AbstractModifierRecipe {
        constructor(id: ResourceLocation_, inputs: Internal.List_<Internal.SizedIngredient>, toolRequirement: Internal.Ingredient_, maxToolSize: number, requirements: Internal.ModifierMatch_, requirementsError: string, result: Internal.ModifierEntry_, maxLevel: number, slots: Internal.SlotType$SlotCount_, allowCrystal: boolean)
        constructor(id: ResourceLocation_, inputs: Internal.List_<Internal.SizedIngredient>, toolRequirement: Internal.Ingredient_, maxToolSize: number, requirements: Internal.ModifierMatch_, requirementsError: string, result: Internal.ModifierEntry_, maxLevel: number, slots: Internal.SlotType$SlotCount_)
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        /**
         * @deprecated
        */
        getRemainingItems(inv: Internal.ITinkerStationContainer_): Internal.NonNullList<Internal.ItemStack>;
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        getSlotType(): Internal.SlotType;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        isIncremental(): boolean;
        getMod(): string;
        static withModifiers(stack: Internal.ItemStack_, match: Internal.ModifierMatch_, newModifier: Internal.ModifierEntry_): Internal.ItemStack;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        /**
         * @deprecated
        */
        getRemainingItems(arg0: net.minecraft.world.Container_): Internal.NonNullList<any>;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        assemble(inv: Internal.ITinkerStationContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        static withModifiers(stack: Internal.ItemStack_, match: Internal.ModifierMatch_, newModifier: Internal.ModifierEntry_, persistentDataConsumer: Internal.Consumer_<Internal.ModDataNBT>): Internal.ItemStack;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        static checkMatch(inv: Internal.ITinkerableContainer_, inputs: Internal.List_<Internal.SizedIngredient>): boolean;
        static updateInputs(inv: Internal.ITinkerableContainer$Mutable_, inputs: Internal.List_<Internal.SizedIngredient>): void;
        getModifier(): Internal.Modifier;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get slotType(): Internal.SlotType
        get incremental(): boolean
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get modifier(): Internal.Modifier
    }
    type ModifierRecipe_ = ModifierRecipe;
    class ItemDreadQueenStaff extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemDreadQueenStaff_ = ItemDreadQueenStaff;
    class GameRenderer implements Internal.GameRendererAccessor, Internal.ResourceManagerReloadListener, net.irisshaders.iris.mixin.GameRendererAccessor, Internal.AutoCloseable, net.createmod.ponder.mixin.client.accessor.GameRendererAccessor {
        constructor($$0: Internal.Minecraft_, $$1: Internal.ItemInHandRenderer_, $$2: Internal.ResourceManager_, $$3: Internal.RenderBuffers_)
        static getRendertypeTextBackgroundShader(): Internal.ShaderInstance;
        static getRendertypeTextIntensityShader(): Internal.ShaderInstance;
        shutdownEffect(): void;
        cycleEffect(): void;
        static getRendertypeEndPortalShader(): Internal.ShaderInstance;
        catnip$callGetFov(arg0: Internal.Camera_, arg1: number, arg2: boolean): number;
        static getRendertypeTripwireShader(): Internal.ShaderInstance;
        resetData(): void;
        loadEffect($$0: ResourceLocation_): void;
        static getPositionColorShader(): Internal.ShaderInstance;
        currentEffect(): Internal.PostChain;
        static getRendertypeTextSeeThroughShader(): Internal.ShaderInstance;
        static getPositionTexColorNormalShader(): Internal.ShaderInstance;
        invokeMethod_3198(arg0: Internal.PoseStack_, arg1: number): void;
        static getRendertypeBeaconBeamShader(): Internal.ShaderInstance;
        static getRendertypeLightningShader(): Internal.ShaderInstance;
        invokeMethod_3196(arg0: Internal.Camera_, arg1: number, arg2: boolean): number;
        static getRendertypeEntitySmoothCutoutShader(): Internal.ShaderInstance;
        setRenderBlockOutline($$0: boolean): void;
        static getRendertypeLeashShader(): Internal.ShaderInstance;
        static getRendertypeArmorCutoutNoCullShader(): Internal.ShaderInstance;
        static getRendertypeGuiGhostRecipeOverlayShader(): Internal.ShaderInstance;
        static getRendertypeArmorEntityGlintShader(): Internal.ShaderInstance;
        invokeMethod_3186(arg0: Internal.PoseStack_, arg1: number): void;
        setPanoramicMode($$0: boolean): void;
        static getRendertypeEntityTranslucentShader(): Internal.ShaderInstance;
        static getRendertypeEntityDecalShader(): Internal.ShaderInstance;
        resize($$0: number, $$1: number): void;
        static getRendertypeTextShader(): Internal.ShaderInstance;
        getRenderDistance(): number;
        getField_4001(): boolean;
        handler$zpg000$architectury$reloadShaders(provider: Internal.ResourceProvider_, ci: Internal.CallbackInfo_, programs: Internal.List_<any>, shaders: Internal.List_<any>): void;
        static getRendertypeSolidShader(): Internal.ShaderInstance;
        static getPositionTexShader(): Internal.ShaderInstance;
        static getRendertypeOutlineShader(): Internal.ShaderInstance;
        static getNightVisionScale($$0: Internal.LivingEntity_, $$1: number): number;
        getDepthFar(): number;
        getDarkenWorldAmount($$0: number): number;
        static getRendertypeEntityGlintShader(): Internal.ShaderInstance;
        static getRendertypeLinesShader(): Internal.ShaderInstance;
        getName(): string;
        static getRendertypeCutoutMippedShader(): Internal.ShaderInstance;
        static getRendertypeEntityTranslucentEmissiveShader(): Internal.ShaderInstance;
        static getPositionColorTexShader(): Internal.ShaderInstance;
        static getRendertypeEntityAlphaShader(): Internal.ShaderInstance;
        abstract onResourceManagerReload(arg0: Internal.ResourceManager_): void;
        handler$fdo000$moonlight$registerShaders(resourceProvider: Internal.ResourceProvider_, ci: Internal.CallbackInfo_, list: Internal.List_<any>): void;
        static getRendertypeEntitySolidShader(): Internal.ShaderInstance;
        getMainCamera(): Internal.Camera;
        static getRendertypeEntityGlintDirectShader(): Internal.ShaderInstance;
        static getRendertypeTranslucentNoCrumblingShader(): Internal.ShaderInstance;
        shouldRenderBlockOutlineA(): boolean;
        port_lib$getFOVModifier(arg0: Internal.Camera_, arg1: number, arg2: boolean): number;
        static getRendertypeEnergySwirlShader(): Internal.ShaderInstance;
        static getPositionTexLightmapColorShader(): Internal.ShaderInstance;
        handler$fjp000$patchouli$renderEnd(tickDelta: number, startTime: number, tick: boolean, info: Internal.CallbackInfo_): void;
        static getRendertypeGlintShader(): Internal.ShaderInstance;
        handler$zpg000$architectury$renderScreenPost(tickDelta: number, startTime: number, tick: boolean, ci: Internal.CallbackInfo_, mouseX: number, mouseY: number, window: com.mojang.blaze3d.platform.Window_, matrix: Matrix4f_, matrices: Internal.PoseStack_, graphics: Internal.GuiGraphics_): void;
        static getRendertypeTranslucentMovingBlockShader(): Internal.ShaderInstance;
        resetProjectionMatrix($$0: Matrix4f_): void;
        static getRendertypeEntityCutoutShader(): Internal.ShaderInstance;
        static getRendertypeTextBackgroundSeeThroughShader(): Internal.ShaderInstance;
        renderZoomed($$0: number, $$1: number, $$2: number): void;
        static getRendertypeGuiTextHighlightShader(): Internal.ShaderInstance;
        getMinecraft(): Internal.Minecraft;
        static getRendertypeEntityShadowShader(): Internal.ShaderInstance;
        static getRendertypeEyesShader(): Internal.ShaderInstance;
        static getRendertypeCutoutShader(): Internal.ShaderInstance;
        static getRendertypeTextIntensitySeeThroughShader(): Internal.ShaderInstance;
        checkEntityPostEffect($$0: Internal.Entity_): void;
        static getRendertypeItemEntityTranslucentCullShader(): Internal.ShaderInstance;
        preloadUiShader($$0: Internal.ResourceProvider_): void;
        overlayTexture(): Internal.OverlayTexture;
        static getRendertypeGuiOverlayShader(): Internal.ShaderInstance;
        isPanoramicMode(): boolean;
        static getRendertypeEntityTranslucentCullShader(): Internal.ShaderInstance;
        handler$ddn000$hexical$renderShader(deltaTick: number, l: number, bl: boolean, ci: Internal.CallbackInfo_): void;
        static getPositionColorTexLightmapShader(): Internal.ShaderInstance;
        lightTexture(): Internal.LightTexture;
        togglePostEffect(): void;
        tick(): void;
        static getRendertypeGuiShader(): Internal.ShaderInstance;
        static getRendertypeEntityCutoutNoCullShader(): Internal.ShaderInstance;
        static getRendertypeTranslucentShader(): Internal.ShaderInstance;
        displayItemActivation($$0: Internal.ItemStack_): void;
        getField_3992(): boolean;
        render($$0: number, $$1: number, $$2: boolean): void;
        static getParticleShader(): Internal.ShaderInstance;
        handler$zpg000$architectury$renderScreenPre(tickDelta: number, startTime: number, tick: boolean, ci: Internal.CallbackInfo_, mouseX: number, mouseY: number, window: com.mojang.blaze3d.platform.Window_, matrix: Matrix4f_, matrices: Internal.PoseStack_, graphics: Internal.GuiGraphics_): void;
        getProjectionMatrix($$0: number): Matrix4f;
        static getRendertypeEntityNoOutlineShader(): Internal.ShaderInstance;
        static getRendertypeWaterMaskShader(): Internal.ShaderInstance;
        static getPositionTexColorShader(): Internal.ShaderInstance;
        static getRendertypeGlintTranslucentShader(): Internal.ShaderInstance;
        renderLevel($$0: number, $$1: number, $$2: Internal.PoseStack_): void;
        handler$hbb000$ratatouille$injectionResizeListener(width: number, height: number, ci: Internal.CallbackInfo_): void;
        static getRendertypeEntityCutoutNoCullZOffsetShader(): Internal.ShaderInstance;
        pick($$0: number): void;
        static getRendertypeArmorGlintShader(): Internal.ShaderInstance;
        static getPositionColorLightmapShader(): Internal.ShaderInstance;
        reload($$0: Internal.PreparableReloadListener$PreparationBarrier_, $$1: Internal.ResourceManager_, $$2: Internal.ProfilerFiller_, $$3: Internal.ProfilerFiller_, $$4: Internal.Executor_, $$5: Internal.Executor_): Internal.CompletableFuture<void>;
        createReloadListener(): Internal.PreparableReloadListener;
        static getRendertypeCrumblingShader(): Internal.ShaderInstance;
        static getRendertypeEndGatewayShader(): Internal.ShaderInstance;
        static getRendertypeGlintDirectShader(): Internal.ShaderInstance;
        getFov($$0: Internal.Camera_, $$1: number, $$2: boolean): number;
        getShader($$0: string): Internal.ShaderInstance;
        handler$fjp000$patchouli$renderStart(tickDelta: number, startTime: number, tick: boolean, info: Internal.CallbackInfo_): void;
        getMapRenderer(): Internal.MapRenderer;
        close(): void;
        static getPositionShader(): Internal.ShaderInstance;
        setRenderHand($$0: boolean): void;
        get rendertypeTextBackgroundShader(): Internal.ShaderInstance
        get rendertypeTextIntensityShader(): Internal.ShaderInstance
        get rendertypeEndPortalShader(): Internal.ShaderInstance
        get rendertypeTripwireShader(): Internal.ShaderInstance
        get positionColorShader(): Internal.ShaderInstance
        get rendertypeTextSeeThroughShader(): Internal.ShaderInstance
        get positionTexColorNormalShader(): Internal.ShaderInstance
        get rendertypeBeaconBeamShader(): Internal.ShaderInstance
        get rendertypeLightningShader(): Internal.ShaderInstance
        get rendertypeEntitySmoothCutoutShader(): Internal.ShaderInstance
        set renderBlockOutline($$0: boolean)
        get rendertypeLeashShader(): Internal.ShaderInstance
        get rendertypeArmorCutoutNoCullShader(): Internal.ShaderInstance
        get rendertypeGuiGhostRecipeOverlayShader(): Internal.ShaderInstance
        get rendertypeArmorEntityGlintShader(): Internal.ShaderInstance
        set panoramicMode($$0: boolean)
        get rendertypeEntityTranslucentShader(): Internal.ShaderInstance
        get rendertypeEntityDecalShader(): Internal.ShaderInstance
        get rendertypeTextShader(): Internal.ShaderInstance
        get renderDistance(): number
        get field_4001(): boolean
        get rendertypeSolidShader(): Internal.ShaderInstance
        get positionTexShader(): Internal.ShaderInstance
        get rendertypeOutlineShader(): Internal.ShaderInstance
        get depthFar(): number
        get rendertypeEntityGlintShader(): Internal.ShaderInstance
        get rendertypeLinesShader(): Internal.ShaderInstance
        get name(): string
        get rendertypeCutoutMippedShader(): Internal.ShaderInstance
        get rendertypeEntityTranslucentEmissiveShader(): Internal.ShaderInstance
        get positionColorTexShader(): Internal.ShaderInstance
        get rendertypeEntityAlphaShader(): Internal.ShaderInstance
        get rendertypeEntitySolidShader(): Internal.ShaderInstance
        get mainCamera(): Internal.Camera
        get rendertypeEntityGlintDirectShader(): Internal.ShaderInstance
        get rendertypeTranslucentNoCrumblingShader(): Internal.ShaderInstance
        get rendertypeEnergySwirlShader(): Internal.ShaderInstance
        get positionTexLightmapColorShader(): Internal.ShaderInstance
        get rendertypeGlintShader(): Internal.ShaderInstance
        get rendertypeTranslucentMovingBlockShader(): Internal.ShaderInstance
        get rendertypeEntityCutoutShader(): Internal.ShaderInstance
        get rendertypeTextBackgroundSeeThroughShader(): Internal.ShaderInstance
        get rendertypeGuiTextHighlightShader(): Internal.ShaderInstance
        get minecraft(): Internal.Minecraft
        get rendertypeEntityShadowShader(): Internal.ShaderInstance
        get rendertypeEyesShader(): Internal.ShaderInstance
        get rendertypeCutoutShader(): Internal.ShaderInstance
        get rendertypeTextIntensitySeeThroughShader(): Internal.ShaderInstance
        get rendertypeItemEntityTranslucentCullShader(): Internal.ShaderInstance
        get rendertypeGuiOverlayShader(): Internal.ShaderInstance
        get panoramicMode(): boolean
        get rendertypeEntityTranslucentCullShader(): Internal.ShaderInstance
        get positionColorTexLightmapShader(): Internal.ShaderInstance
        get rendertypeGuiShader(): Internal.ShaderInstance
        get rendertypeEntityCutoutNoCullShader(): Internal.ShaderInstance
        get rendertypeTranslucentShader(): Internal.ShaderInstance
        get field_3992(): boolean
        get particleShader(): Internal.ShaderInstance
        get rendertypeEntityNoOutlineShader(): Internal.ShaderInstance
        get rendertypeWaterMaskShader(): Internal.ShaderInstance
        get positionTexColorShader(): Internal.ShaderInstance
        get rendertypeGlintTranslucentShader(): Internal.ShaderInstance
        get rendertypeEntityCutoutNoCullZOffsetShader(): Internal.ShaderInstance
        get rendertypeArmorGlintShader(): Internal.ShaderInstance
        get positionColorLightmapShader(): Internal.ShaderInstance
        get rendertypeCrumblingShader(): Internal.ShaderInstance
        get rendertypeEndGatewayShader(): Internal.ShaderInstance
        get rendertypeGlintDirectShader(): Internal.ShaderInstance
        get mapRenderer(): Internal.MapRenderer
        get positionShader(): Internal.ShaderInstance
        set renderHand($$0: boolean)
        static readonly PROJECTION_Z_NEAR: 0.05;
        static readonly EFFECT_NONE: 24;
        static readonly ITEM_ACTIVATION_ANIMATION_LENGTH: 40;
        blitShader: Internal.ShaderInstance;
        readonly itemInHandRenderer: Internal.ItemInHandRenderer;
    }
    type GameRenderer_ = GameRenderer;
    class MolecularAssemblerBlock extends Internal.AEBaseEntityBlock<any> {
        constructor(props: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly POWERED: Internal.BooleanProperty;
    }
    type MolecularAssemblerBlock_ = MolecularAssemblerBlock;
    class AutoSmeltingUpgradeItem extends Internal.UpgradeItemBase<Internal.AutoCookingUpgradeWrapper$AutoSmeltingUpgradeWrapper> implements Internal.IAutoCookingUpgradeItem {
        constructor(autoSmeltingUpgradeConfig: Internal.AutoCookingUpgradeConfig_, upgradeTypeLimitConfig: any_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        setAttackSpeed(attackSpeed: number): void;
        getType(): Internal.UpgradeType<Internal.AutoCookingUpgradeWrapper$AutoSmeltingUpgradeWrapper>;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getInventoryColumnsTaken(): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        emi(amount: number): Internal.EmiStack;
        getAutoCookingUpgradeConfig(): Internal.AutoCookingUpgradeConfig;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get type(): Internal.UpgradeType<Internal.AutoCookingUpgradeWrapper$AutoSmeltingUpgradeWrapper>
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get inventoryColumnsTaken(): number
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get autoCookingUpgradeConfig(): Internal.AutoCookingUpgradeConfig
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly TYPE: Internal.UpgradeType<Internal.AutoCookingUpgradeWrapper$AutoSmeltingUpgradeWrapper>;
    }
    type AutoSmeltingUpgradeItem_ = AutoSmeltingUpgradeItem;
    class ModelGenerator$Element {
        constructor()
        box(b: Internal.AABB_): this;
        face(direction: Internal.Direction_, consumer: Internal.Consumer_<Internal.ModelGenerator$Face>): void;
        toJson(): Internal.JsonObject;
    }
    type ModelGenerator$Element_ = ModelGenerator$Element;
    interface WidgetTooltipHolder <T> {
        abstract tooltip(arg0: Internal.BiFunction_<number, number, Internal.List<Internal.ClientTooltipComponent>>): T;
        tooltip(tooltip: Internal.List_<Internal.ClientTooltipComponent>): T;
        tooltipText(tooltipSupplier: Internal.BiFunction_<number, number, Internal.List<net.minecraft.network.chat.Component>>): T;
        tooltipText(tooltip: Internal.List_<net.minecraft.network.chat.Component>): T;
        (arg0: Internal.BiFunction<number, number, Internal.List<Internal.ClientTooltipComponent>>): T;
    }
    type WidgetTooltipHolder_<T> = WidgetTooltipHolder<T>;
    class BlockHexWoodButton extends Internal.ButtonBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        isFlammable(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, direction: Internal.Direction_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getFireSpreadSpeed(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, direction: Internal.Direction_): number;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getFlammability(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, direction: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockHexWoodButton_ = BlockHexWoodButton;
    interface AnimatedTextureDuck {
        abstract railways$uploadWithVisibility(): void;
        (): void;
    }
    type AnimatedTextureDuck_ = AnimatedTextureDuck;
    class TurtleAnimation extends Internal.Enum<Internal.TurtleAnimation> {
        static valueOf(name: string): Internal.TurtleAnimation;
        static values(): Internal.TurtleAnimation[];
        static readonly TURN_RIGHT: Internal.TurtleAnimation;
        static readonly SHORT_WAIT: Internal.TurtleAnimation;
        static readonly TURN_LEFT: Internal.TurtleAnimation;
        static readonly NONE: Internal.TurtleAnimation;
        static readonly MOVE_DOWN: Internal.TurtleAnimation;
        static readonly SWING_LEFT_TOOL: Internal.TurtleAnimation;
        static readonly MOVE_BACK: Internal.TurtleAnimation;
        static readonly MOVE_UP: Internal.TurtleAnimation;
        static readonly MOVE_FORWARD: Internal.TurtleAnimation;
        static readonly WAIT: Internal.TurtleAnimation;
        static readonly SWING_RIGHT_TOOL: Internal.TurtleAnimation;
    }
    type TurtleAnimation_ = "turn_right" | "wait" | "move_forward" | "turn_left" | "move_down" | "swing_right_tool" | "move_up" | TurtleAnimation | "short_wait" | "none" | "move_back" | "swing_left_tool";
    class StructureTemplate$Palette {
        blocks(): Internal.List<Internal.StructureTemplate$StructureBlockInfo>;
        blocks($$0: Internal.Block_): Internal.List<Internal.StructureTemplate$StructureBlockInfo>;
    }
    type StructureTemplate$Palette_ = StructureTemplate$Palette;
    interface Long2ReferenceFunction <V> extends it.unimi.dsi.fastutil.Function<number, V>, Internal.LongFunction<V> {
        andThenShort(arg0: Internal.Reference2ShortFunction_<V>): Internal.Long2ShortFunction;
        composeByte(arg0: Internal.Byte2LongFunction_): Internal.Byte2ReferenceFunction<V>;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        composeReference<T>(arg0: Internal.Reference2LongFunction_<T>): Internal.Reference2ReferenceFunction<T, V>;
        andThenByte(arg0: Internal.Reference2ByteFunction_<V>): Internal.Long2ByteFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        andThenLong(arg0: Internal.Reference2LongFunction_<V>): Internal.Long2LongFunction;
        remove(arg0: number): V;
        andThenDouble(arg0: Internal.Reference2DoubleFunction_<V>): Internal.Long2DoubleFunction;
        andThenChar(arg0: Internal.Reference2CharFunction_<V>): Internal.Long2CharFunction;
        andThenObject<T>(arg0: Internal.Reference2ObjectFunction_<V, T>): Internal.Long2ObjectFunction<T>;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeInt(arg0: Internal.Int2LongFunction_): Internal.Int2ReferenceFunction<V>;
        put(arg0: number, arg1: V): V;
        apply(arg0: number): V;
        composeFloat(arg0: Internal.Float2LongFunction_): Internal.Float2ReferenceFunction<V>;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: V): V;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        composeChar(arg0: Internal.Char2LongFunction_): Internal.Char2ReferenceFunction<V>;
        composeObject<T>(arg0: Internal.Object2LongFunction_<T>): Internal.Object2ReferenceFunction<T, V>;
        apply(arg0: number): V;
        composeShort(arg0: Internal.Short2LongFunction_): Internal.Short2ReferenceFunction<V>;
        andThenReference<T>(arg0: Internal.Reference2ReferenceFunction_<V, T>): Internal.Long2ReferenceFunction<T>;
        containsKey(arg0: number): boolean;
        andThenInt(arg0: Internal.Reference2IntFunction_<V>): Internal.Long2IntFunction;
        composeLong(arg0: Internal.Long2LongFunction_): this;
        andThenFloat(arg0: Internal.Reference2FloatFunction_<V>): Internal.Long2FloatFunction;
        composeDouble(arg0: Internal.Double2LongFunction_): Internal.Double2ReferenceFunction<V>;
        abstract get(arg0: number): V;
        size(): number;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        clear(): void;
        defaultReturnValue(): V;
        getOrDefault(arg0: number, arg1: V): V;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: V): void;
        (arg0: number): V;
    }
    type Long2ReferenceFunction_<V> = Long2ReferenceFunction<V>;
    interface FabricClientCommandSource extends Internal.ClientCommandRegistrationEvent$ClientCommandSourceStack, Internal.SharedSuggestionProvider {
        abstract sendFeedback(arg0: net.minecraft.network.chat.Component_): void;
        getSelectedEntities(): Internal.Collection<string>;
        getPosition(): Vec3d;
        getMeta(key: string): any;
        suggestCoordinates($$0: string, $$1: Internal.Collection_<Internal.SharedSuggestionProvider$TextCoordinates>, $$2: Internal.SuggestionsBuilder_, $$3: Internal.Predicate_<string>): Internal.CompletableFuture<Internal.Suggestions>;
        suggestResource($$0: Internal.Stream_<ResourceLocation>, $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        suggest($$0: Internal.Stream_<string>, $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        suggest($$0: string[], $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        arch$getPosition(): Vec3d;
        abstract hasPermission(arg0: number): boolean;
        suggestResource<T>($$0: Internal.Iterable_<T>, $$1: Internal.SuggestionsBuilder_, $$2: Internal.Function_<T, ResourceLocation>, $$3: Internal.Function_<T, Internal.Message>): Internal.CompletableFuture<Internal.Suggestions>;
        getCustomTabSugggestions(): Internal.Collection<string>;
        getRotation(): Internal.Vec2;
        abstract getRecipeNames(): Internal.Stream<ResourceLocation>;
        arch$sendFailure(message: net.minecraft.network.chat.Component_): void;
        abstract getWorld(): Internal.ClientLevel;
        suggestResource($$0: Internal.Stream_<ResourceLocation>, $$1: Internal.SuggestionsBuilder_, $$2: string): Internal.CompletableFuture<Internal.Suggestions>;
        filterResources<T>($$0: Internal.Iterable_<T>, $$1: string, $$2: Internal.Function_<T, ResourceLocation>, $$3: Internal.Consumer_<T>): void;
        matchesSubStr($$0: string, $$1: string): boolean;
        abstract getPlayer(): Internal.LocalPlayer;
        arch$sendSuccess(message: Internal.Supplier_<any>, broadcastToAdmins: boolean): void;
        suggest2DCoordinates($$0: string, $$1: Internal.Collection_<Internal.SharedSuggestionProvider$TextCoordinates>, $$2: Internal.SuggestionsBuilder_, $$3: Internal.Predicate_<string>): Internal.CompletableFuture<Internal.Suggestions>;
        suggest<T>($$0: Internal.Iterable_<T>, $$1: Internal.SuggestionsBuilder_, $$2: Internal.Function_<T, string>, $$3: Internal.Function_<T, Internal.Message>): Internal.CompletableFuture<Internal.Suggestions>;
        abstract customSuggestion(arg0: Internal.CommandContext_<any>): Internal.CompletableFuture<Internal.Suggestions>;
        suggestResource($$0: Internal.Iterable_<ResourceLocation>, $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        suggest($$0: Internal.Iterable_<string>, $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        suggestRegistryElements($$0: Internal.Registry_<any>, $$1: Internal.SharedSuggestionProvider$ElementSuggestionType_, $$2: Internal.SuggestionsBuilder_): void;
        abstract getAvailableSounds(): Internal.Stream<ResourceLocation>;
        abstract enabledFeatures(): Internal.FeatureFlagSet;
        abstract suggestRegistryElements(arg0: Internal.ResourceKey_<Internal.Registry<any>>, arg1: Internal.SharedSuggestionProvider$ElementSuggestionType_, arg2: Internal.SuggestionsBuilder_, arg3: Internal.CommandContext_<any>): Internal.CompletableFuture<Internal.Suggestions>;
        abstract getAllTeams(): Internal.Collection<string>;
        abstract sendError(arg0: net.minecraft.network.chat.Component_): void;
        filterResources<T>($$0: Internal.Iterable_<T>, $$1: string, $$2: string, $$3: Internal.Function_<T, ResourceLocation>, $$4: Internal.Consumer_<T>): void;
        abstract registryAccess(): Internal.RegistryAccess;
        getRelevantCoordinates(): Internal.Collection<Internal.SharedSuggestionProvider$TextCoordinates>;
        getAbsoluteCoordinates(): Internal.Collection<Internal.SharedSuggestionProvider$TextCoordinates>;
        arch$getLevel(): Internal.ClientLevel;
        abstract getClient(): Internal.Minecraft;
        getEntity(): Internal.Entity;
        suggestResource($$0: Internal.Iterable_<ResourceLocation>, $$1: Internal.SuggestionsBuilder_, $$2: string): Internal.CompletableFuture<Internal.Suggestions>;
        arch$getPlayer(): Internal.LocalPlayer;
        arch$getRotation(): Internal.Vec2;
        abstract levels(): Internal.Set<Internal.ResourceKey<Internal.Level>>;
        abstract getOnlinePlayerNames(): Internal.Collection<string>;
        suggestResource<T>($$0: Internal.Stream_<T>, $$1: Internal.SuggestionsBuilder_, $$2: Internal.Function_<T, ResourceLocation>, $$3: Internal.Function_<T, Internal.Message>): Internal.CompletableFuture<Internal.Suggestions>;
        get selectedEntities(): Internal.Collection<string>
        get position(): Vec3d
        get customTabSugggestions(): Internal.Collection<string>
        get rotation(): Internal.Vec2
        get recipeNames(): Internal.Stream<ResourceLocation>
        get world(): Internal.ClientLevel
        get player(): Internal.LocalPlayer
        get availableSounds(): Internal.Stream<ResourceLocation>
        get allTeams(): Internal.Collection<string>
        get relevantCoordinates(): Internal.Collection<Internal.SharedSuggestionProvider$TextCoordinates>
        get absoluteCoordinates(): Internal.Collection<Internal.SharedSuggestionProvider$TextCoordinates>
        get client(): Internal.Minecraft
        get entity(): Internal.Entity
        get onlinePlayerNames(): Internal.Collection<string>
    }
    type FabricClientCommandSource_ = FabricClientCommandSource;
    interface IntList extends Internal.List<number>, Internal.Comparable<Internal.List<number>>, Internal.IntCollection {
        /**
         * @deprecated
        */
        stream(): Internal.Stream<number>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        of<E>(arg0: E): Internal.List<E>;
        unstableSort(arg0: Internal.IntComparator_): void;
        abstract addAll(arg0: number, arg1: Internal.Collection_<number>): boolean;
        intStream(): Internal.IntStream;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        reversed(): Internal.SequencedCollection<any>;
        abstract removeAll(arg0: Internal.IntCollection_): boolean;
        getFirst(): number;
        addFirst(arg0: number): void;
        /**
         * @deprecated
        */
        set(arg0: number, arg1: number): number;
        removeIf(arg0: Internal.IntPredicate_): boolean;
        of(arg0: number, arg1: number): this;
        of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        abstract addAll(arg0: Internal.IntCollection_): boolean;
        abstract retainAll(arg0: Internal.IntCollection_): boolean;
        /**
         * @deprecated
        */
        indexOf(arg0: any): number;
        of(arg0: number, arg1: number, arg2: number): this;
        abstract getElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        abstract toArray<T>(arg0: T[]): T[];
        /**
         * @deprecated
        */
        toIntArray(arg0: number[]): number[];
        /**
         * @deprecated
        */
        remove(arg0: any): boolean;
        /**
         * @deprecated
        */
        add(arg0: any): boolean;
        abstract compareTo(arg0: Internal.List_<number>): number;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        /**
         * @deprecated
        */
        set(arg0: number, arg1: any): any;
        /**
         * @deprecated
        */
        lastIndexOf(arg0: any): number;
        addAll(arg0: Internal.IntList_): boolean;
        getLast(): number;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        abstract iterator(): Internal.IntListIterator;
        sort(arg0: Internal.IntComparator_): void;
        removeLast(): number;
        forEach(arg0: Internal.IntConsumer_): void;
        listIterator(arg0: number): Internal.ListIterator<any>;
        /**
         * @deprecated
        */
        add(arg0: number, arg1: number): void;
        /**
         * @deprecated
        */
        contains(arg0: any): boolean;
        setElements(arg0: number[]): void;
        forEach(arg0: it.unimi.dsi.fastutil.ints.IntConsumer_): void;
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<number>): void;
        /**
         * @deprecated
        */
        parallelStream(): Internal.Stream<number>;
        replaceAll(arg0: Internal.IntUnaryOperator_): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        replaceAll(arg0: it.unimi.dsi.fastutil.ints.IntUnaryOperator_): void;
        of(...arg0: number[]): this;
        /**
         * @deprecated
        */
        removeIf(arg0: Internal.Predicate_<number>): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        /**
         * @deprecated
        */
        get(arg0: number): any;
        subList(arg0: number, arg1: number): Internal.List<any>;
        abstract size(): number;
        setElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        abstract clear(): void;
        abstract rem(arg0: number): boolean;
        abstract addElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        abstract addAll(arg0: Internal.Collection_<number>): boolean;
        addLast(arg0: number): void;
        abstract contains(arg0: number): boolean;
        /**
         * @deprecated
        */
        add(arg0: number, arg1: any): void;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        of(): this;
        intParallelStream(): Internal.IntStream;
        removeFirst(): number;
        intIterator(): Internal.IntIterator;
        listIterator(): Internal.ListIterator<any>;
        abstract size(arg0: number): void;
        abstract indexOf(arg0: number): number;
        abstract addElements(arg0: number, arg1: number[]): void;
        abstract add(arg0: number): boolean;
        abstract containsAll(arg0: Internal.IntCollection_): boolean;
        of(arg0: number): this;
        /**
         * @deprecated
        */
        replaceAll(arg0: Internal.UnaryOperator_<number>): void;
        abstract lastIndexOf(arg0: number): number;
        /**
         * @deprecated
        */
        unstableSort(arg0: Internal.Comparator_<number>): void;
        abstract addAll(arg0: number, arg1: Internal.IntCollection_): boolean;
        of<E>(arg0: E, arg1: E): Internal.List<E>;
        spliterator(): Internal.Spliterator<any>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        /**
         * @deprecated
        */
        sort(arg0: Internal.Comparator_<number>): void;
        abstract set(arg0: number, arg1: number): number;
        abstract removeElements(arg0: number, arg1: number): void;
        /**
         * @deprecated
        */
        remove(arg0: number): any;
        /**
         * @deprecated
        */
        add(arg0: number): boolean;
        abstract isEmpty(): boolean;
        abstract toIntArray(): number[];
        of<E>(...arg0: E[]): Internal.List<E>;
        addAll(arg0: number, arg1: Internal.IntList_): boolean;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        setElements(arg0: number, arg1: number[]): void;
        abstract toArray(arg0: number[]): number[];
        abstract getInt(arg0: number): number;
        abstract removeInt(arg0: number): number;
        abstract add(arg0: number, arg1: number): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        abstract toArray(): any[];
        removeIf(arg0: it.unimi.dsi.fastutil.ints.IntPredicate_): boolean;
        intSpliterator(): Internal.IntSpliterator;
        abstract hashCode(): number;
        abstract equals(arg0: any): boolean;
        get first(): number
        get last(): number
        set elements(arg0: number[])
        get empty(): boolean
    }
    type IntList_ = IntList;
    abstract class IafJigsawStructure extends Internal.Structure {
        constructor(config: Internal.Structure$StructureSettings_, startPool: Internal.Holder_<Internal.StructureTemplatePool>, startJigsawName: Internal.Optional_<ResourceLocation>, size: number, startHeight: Internal.HeightProvider_, projectStartToHeightmap: Internal.Optional_<Internal.Heightmap$Types>, maxDistanceFromCenter: number)
    }
    type IafJigsawStructure_ = IafJigsawStructure;
    class ValueLayouts$OfAddressImpl extends Internal.ValueLayouts$AbstractValueLayout<Internal.ValueLayouts$OfAddressImpl> implements Internal.AddressLayout {
        static sequenceLayout(arg0: number, arg1: Internal.MemoryLayout_): Internal.SequenceLayout;
        static sequenceLayout(arg0: Internal.MemoryLayout_): Internal.SequenceLayout;
        withoutTargetLayout(): Internal.AddressLayout;
        withTargetLayout(arg0: Internal.MemoryLayout_): Internal.AddressLayout;
        byteOffset(...arg0: any_[]): number;
        targetLayout(): Internal.Optional<Internal.MemoryLayout>;
        withByteAlignment(arg0: number): Internal.MemoryLayout;
        withOrder(arg0: Internal.ByteOrder_): Internal.ValueLayout;
        static structLayout(...arg0: Internal.MemoryLayout_[]): Internal.StructLayout;
        withoutName(): Internal.ValueLayout;
        withName(arg0: string): Internal.AddressLayout;
        select(...arg0: any_[]): Internal.MemoryLayout;
        sliceHandle(...arg0: any_[]): Internal.MethodHandle;
        static paddingLayout(arg0: number): Internal.PaddingLayout;
        varHandle(...arg0: any_[]): Internal.VarHandle;
        byteOffsetHandle(...arg0: any_[]): Internal.MethodHandle;
        static unionLayout(...arg0: Internal.MemoryLayout_[]): Internal.UnionLayout;
        static of(arg0: Internal.ByteOrder_): Internal.AddressLayout;
    }
    type ValueLayouts$OfAddressImpl_ = ValueLayouts$OfAddressImpl;
    class BlockExIOPort extends Internal.BlockBaseGui<Internal.TileExIOPort> {
        constructor()
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        openGui(tile: Internal.TileExIOPort_, p: Internal.Player_): void;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly POWERED: Internal.BooleanProperty;
    }
    type BlockExIOPort_ = BlockExIOPort;
    class FaceBakery {
        constructor()
        recalculateWinding($$0: number[], $$1: Internal.Direction_): void;
        static recomputeUVs($$0: Internal.BlockFaceUV_, $$1: Internal.Direction_, $$2: Internal.Transformation_, $$3: ResourceLocation_): Internal.BlockFaceUV;
        applyElementRotation($$0: Vec3f_, $$1: Internal.BlockElementRotation_): void;
        setupShape($$0: Vec3f_, $$1: Vec3f_): number[];
        static calculateFacing($$0: number[]): Internal.Direction;
        applyModelRotation($$0: Vec3f_, $$1: Internal.Transformation_): void;
        bakeQuad($$0: Vec3f_, $$1: Vec3f_, $$2: Internal.BlockElementFace_, $$3: Internal.TextureAtlasSprite_, $$4: Internal.Direction_, $$5: Internal.ModelState_, $$6: Internal.BlockElementRotation_, $$7: boolean, $$8: ResourceLocation_): Internal.BakedQuad;
        static readonly UV_INDEX: 4;
        static readonly VERTEX_INT_SIZE: 8;
        static readonly VERTEX_COUNT: 4;
    }
    type FaceBakery_ = FaceBakery;
    class SimpleFlowableFluid$Still extends Internal.SimpleFlowableFluid {
        constructor(properties: any_)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type SimpleFlowableFluid$Still_ = SimpleFlowableFluid$Still;
    class ObservePacket extends Internal.Record {
        constructor(pos: BlockPos_, node: number)
        encode(): Internal.FriendlyByteBuf;
        static handle(pkt: Internal.ObservePacket_, server: Internal.MinecraftServer_, player: Internal.ServerPlayer_): void;
        static decode(buf: Internal.FriendlyByteBuf_): Internal.ObservePacket;
        pos(): BlockPos;
        static send(pos: BlockPos_, node: number): boolean;
        node(): number;
        static tick(): void;
    }
    type ObservePacket_ = ObservePacket;
    interface BlockTintFunction {
        of(cx: Internal.Context_, o: any): this;
        abstract getColor(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: number): dev.latvian.mods.rhino.mod.util.color.Color;
        (arg0: Internal.BlockState, arg1: Internal.BlockAndTintGetter, arg2: BlockPos, arg3: number): dev.latvian.mods.rhino.mod.util.color.Color_;
        readonly BIRCH_FOLIAGE: Internal.BlockTintFunction$Fixed;
        readonly EVERGREEN_FOLIAGE: Internal.BlockTintFunction$Fixed;
        readonly WATER: Internal.BlockTintFunction;
        readonly REDSTONE: Internal.BlockTintFunction;
        readonly FOLIAGE: Internal.BlockTintFunction;
        readonly GRASS: Internal.BlockTintFunction;
        readonly DEFAULT_FOLIAGE_COLOR: Internal.SimpleColor;
        readonly MANGROVE_FOLIAGE: Internal.BlockTintFunction$Fixed;
        readonly REDSTONE_COLORS: dev.latvian.mods.rhino.mod.util.color.Color[];
    }
    type BlockTintFunction_ = BlockTintFunction;
    class ParticleSpray {
        constructor(pos: Vec3d_, vel: Vec3d_, fuzziness: number, spread: number, count: number)
        constructor(arg0: Vec3d_, arg1: Vec3d_, arg2: number, arg3: number, arg4: number, arg5: number, arg6: any_)
        getCount(): number;
        component5(): number;
        component2(): Vec3d;
        component1(): Vec3d;
        getSpread(): number;
        component4(): number;
        sprayParticles(world: Internal.ServerLevel_, color: Internal.FrozenPigment_): void;
        component3(): number;
        copy(pos: Vec3d_, vel: Vec3d_, fuzziness: number, spread: number, count: number): this;
        getVel(): Vec3d;
        static cloud(pos: Vec3d_, size: number, count: number): Internal.ParticleSpray;
        static copy$default(arg0: Internal.ParticleSpray_, arg1: Vec3d_, arg2: Vec3d_, arg3: number, arg4: number, arg5: number, arg6: number, arg7: any): Internal.ParticleSpray;
        static burst(pos: Vec3d_, size: number, count: number): Internal.ParticleSpray;
        getFuzziness(): number;
        getPos(): Vec3d;
        get count(): number
        get spread(): number
        get vel(): Vec3d
        get fuzziness(): number
        get pos(): Vec3d
        static readonly Companion: Internal.ParticleSpray$Companion;
    }
    type ParticleSpray_ = ParticleSpray;
    abstract class Point2D implements Internal.Cloneable {
        clone(): any;
        distanceSq(arg0: number, arg1: number): number;
        abstract getX(): number;
        static distanceSq(arg0: number, arg1: number, arg2: number, arg3: number): number;
        abstract getY(): number;
        setLocation(arg0: Internal.Point2D_): void;
        distance(arg0: number, arg1: number): number;
        static distance(arg0: number, arg1: number, arg2: number, arg3: number): number;
        distanceSq(arg0: Internal.Point2D_): number;
        abstract setLocation(arg0: number, arg1: number): void;
        distance(arg0: Internal.Point2D_): number;
        get x(): number
        get y(): number
        set location(arg0: Internal.Point2D_)
    }
    type Point2D_ = Point2D;
    abstract class BaseEvent {
        constructor()
        getResult(): Internal.BaseEvent$Result;
        setCanceled(cancelled: boolean): void;
        abstract sendEvent(): void;
        isCanceled(): boolean;
        post(): boolean;
        setResult(value: Internal.BaseEvent$Result_): void;
        get result(): Internal.BaseEvent$Result
        set canceled(cancelled: boolean)
        get canceled(): boolean
        set result(value: Internal.BaseEvent$Result_)
    }
    type BaseEvent_ = BaseEvent;
}
declare namespace com.railwayteam.railways.mixin.conductor_possession {
    interface AccessorKeyMapping {
        abstract getKey(): Internal.InputConstants$Key;
        get key(): Internal.InputConstants$Key
        (): Internal.InputConstants$Key_;
    }
    type AccessorKeyMapping_ = AccessorKeyMapping;
}
declare namespace io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor {
    interface RecipeManagerAccessor {
        abstract port_lib$getRecipes(): Internal.Map<Internal.RecipeType<any>, Internal.Map<ResourceLocation, Internal.Recipe<any>>>;
        abstract port_lib$byType<C extends net.minecraft.world.Container, T extends Internal.Recipe<C>>(arg0: Internal.RecipeType_<T>): Internal.Map<ResourceLocation, Internal.Recipe<C>>;
    }
    type RecipeManagerAccessor_ = RecipeManagerAccessor;
}
declare namespace dev.lambdaurora.lambdynlights.shadow.nightconfig.core {
    interface UnmodifiableConfig$Entry {
        getChar(): string;
        getShortOrElse(defaultValue: number): number;
        getByte(): number;
        abstract getKey(): string;
        abstract getRawValue<T>(): T;
        getIntOrElse(defaultValue: number): number;
        getLongOrElse(defaultValue: number): number;
        getOptionalLong(): Internal.OptionalLong;
        getLong(): number;
        getByteOrElse(defaultValue: number): number;
        getShort(): number;
        getValue<T>(): T;
        isNull(): boolean;
        getOrElse<T>(defaultValue: T): T;
        getOptionalInt(): Internal.OptionalInt;
        getOptional<T>(): Internal.Optional<T>;
        getInt(): number;
        getCharOrElse(defaultValue: string): string;
        get "char"(): string
        get "byte"(): number
        get key(): string
        get rawValue(): T
        get optionalLong(): Internal.OptionalLong
        get "long"(): number
        get "short"(): number
        get value(): T
        get "null"(): boolean
        get optionalInt(): Internal.OptionalInt
        get optional(): Internal.Optional<T>
        get "int"(): number
    }
    type UnmodifiableConfig$Entry_ = UnmodifiableConfig$Entry;
}
